/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.Set;
import collections.UpdatableSet;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.CyclicHierarchyException;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.SimpleConcept;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ConceptImpl
extends SimpleConcept {
    private String name;
    private boolean newExtensional = false;
    private boolean extensional = false;
    private UpdatableSet subsumes;
    private UpdatableSet subsumedBy;
    protected ConceptSet directSubs = new ConceptSet();
    protected ConceptSet directSupers = new ConceptSet();
    private OrderedTable newApprop = new OrderedTable();
    private OrderedTable approp;
    private boolean restricted = true;
    UpdatableSet partitions = new HashedSet();

    ConceptImpl() {
        this.name = "Top";
        this.transitiveClosure();
    }

    public ConceptImpl(String string, ConceptImpl[] conceptImplArray) throws TypeException {
        this(string);
        int n = 0;
        while (n < conceptImplArray.length) {
            this.addIsa(conceptImplArray[n]);
            ++n;
        }
    }

    public ConceptImpl(String string, ConceptImpl conceptImpl) throws TypeException {
        this(string, new ConceptImpl[]{conceptImpl});
    }

    public ConceptImpl(String string) {
        this.subsumes = new HashedSet();
        this.subsumes.include(this);
        if (!this.setName(string)) {
            throw new RuntimeException("Concept " + string + " already exists!");
        }
        TypeSystem.instance().transitiveClosure();
    }

    public ConceptImpl(String string, boolean bl, boolean bl2) {
        this(string);
        this.extensional = bl;
        this.restricted = bl2;
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.equals(this.name)) {
            return true;
        }
        TypeSystem typeSystem = TypeSystem.instance();
        if (typeSystem.hasConcept(string)) {
            System.err.println("Concept " + string + " already exists!");
            return false;
        }
        if (this.name != null) {
            typeSystem.removeConcept(this);
        }
        this.name = string;
        typeSystem.addConcept(this);
        return true;
    }

    public boolean isExtensional() {
        return this.extensional;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public boolean isApprop(Name name) {
        return !this.restricted || this.approp.includesKey(name);
    }

    public Type appropType(Name name) throws NoSuchElementException {
        try {
            return new ConjunctiveType(this.appropConcepts(name));
        }
        catch (UnificationFailure unificationFailure) {
            throw new RuntimeException("The ConjunctiveType " + this.appropConcepts(name) + " is not defined!");
        }
    }

    public ConceptSet appropConcepts(Name name) throws NoSuchElementException {
        if (!this.restricted) {
            return new ConceptSet();
        }
        if (this.approp.includesKey(name)) {
            return (ConceptSet)this.approp.at(name);
        }
        throw new NoSuchElementException();
    }

    public Enumeration appropFeatureNames() {
        if (this.restricted) {
            return this.approp.keys();
        }
        return new Vector().elements();
    }

    void inherit(UpdatableSet updatableSet) throws TypeException {
        updatableSet.include(this);
        ConceptEnumeration conceptEnumeration = this.directSubs.elements();
        while (conceptEnumeration.hasMoreElements()) {
            ConceptImpl conceptImpl = (ConceptImpl)conceptEnumeration.nextConcept();
            if (this.extensional) {
                if (!conceptImpl.extensional) {
                    conceptImpl.extensional = true;
                    conceptImpl.subsumedBy = new HashedSet();
                    conceptImpl.subsumedBy.include(conceptImpl);
                }
                conceptImpl.subsumedBy.include(this);
            }
            boolean bl = false;
            int n = 0;
            Enumeration enumeration = this.approp.keys();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                ConceptSet conceptSet = (ConceptSet)this.approp.at(name);
                if (conceptImpl.isApprop(name)) {
                    ConceptSet conceptSet2 = (ConceptSet)conceptImpl.approp.at(name);
                    conceptSet.unite(conceptSet2);
                    conceptImpl.approp.insertAt(name, n++, conceptSet);
                    if (conceptSet.equals(conceptSet2)) continue;
                    bl = true;
                    continue;
                }
                conceptImpl.approp.insertAt(name, n++, conceptSet);
                bl = true;
            }
            if (!bl && updatableSet.includes(conceptImpl)) continue;
            conceptImpl.inherit(updatableSet);
        }
    }

    protected void transitiveClosure() {
        this.subsumes = new HashedSet();
        this.subsumes.include(this);
        ConceptEnumeration conceptEnumeration = this.directSubs.elements();
        while (conceptEnumeration.hasMoreElements()) {
            ConceptImpl conceptImpl = (ConceptImpl)conceptEnumeration.nextConcept();
            conceptImpl.transitiveClosure();
            this.subsumes.includeElements(conceptImpl.subsumes.elements());
        }
    }

    void recalcDirectIsa(UpdatableSet updatableSet) throws TypeException {
        if (!updatableSet.includes(this)) {
            updatableSet.include(this);
            try {
                this.directSupers.join();
            }
            catch (UnificationFailure unificationFailure) {
                TypeException typeException = new TypeException(this);
                throw typeException;
            }
            this.directSubs.meet();
            this.extensional = this.newExtensional;
            if (this.extensional) {
                this.subsumedBy = new HashedSet();
                this.subsumedBy.include(this);
            } else {
                this.subsumedBy = null;
            }
            this.approp = (OrderedTable)this.newApprop.clone();
            ConceptEnumeration conceptEnumeration = this.directSubs.elements();
            while (conceptEnumeration.hasMoreElements()) {
                ((ConceptImpl)conceptEnumeration.nextElement()).recalcDirectIsa(updatableSet);
            }
        }
    }

    void basicAddIsa(ConceptImpl conceptImpl) {
        this.directSupers.addConcept(conceptImpl);
        conceptImpl.directSubs.addConcept(this);
    }

    public void addIsa(ConceptImpl conceptImpl) throws CyclicHierarchyException, TypeException {
        if (conceptImpl.isa(this)) {
            throw new CyclicHierarchyException();
        }
        if (this.isa(conceptImpl)) {
            return;
        }
        this.basicAddIsa(conceptImpl);
        TypeSystem.instance().recalcDirectIsa();
    }

    public void addApprop(String string, ConceptSet conceptSet) {
        this.addApprop(new Name(string), conceptSet);
    }

    public void addApprop(Name name, ConceptSet conceptSet) {
        this.newApprop.putAt(name, conceptSet);
    }

    public void setApprops(OrderedTable orderedTable) {
        this.newApprop = (OrderedTable)orderedTable.clone();
    }

    void buildFeatureTypes(UpdatableSet updatableSet) throws TypeException {
        if (!updatableSet.includes(this)) {
            Object object;
            updatableSet.include(this);
            Enumeration enumeration = this.approp.keys();
            while (enumeration.hasMoreElements()) {
                object = (Name)enumeration.nextElement();
                ConceptSet conceptSet = (ConceptSet)this.approp.at(object);
                try {
                    new ConjunctiveType(conceptSet);
                }
                catch (UnificationFailure unificationFailure) {
                    throw new TypeException(this, (Name)object);
                }
            }
            object = this.directSubs.elements();
            while (object.hasMoreElements()) {
                ((ConceptImpl)object.nextElement()).buildFeatureTypes(updatableSet);
            }
        }
    }

    public boolean isa(Concept concept) {
        if (concept instanceof ConceptImpl) {
            return ((ConceptImpl)concept).subsumes.includes(this);
        }
        return false;
    }

    public Enumeration getPartitions() {
        return this.partitions.elements();
    }

    public boolean isNotA(Concept concept) {
        if (this == concept) {
            return false;
        }
        if (concept instanceof ConceptImpl) {
            ConceptImpl conceptImpl = (ConceptImpl)concept;
            if (this.intersects(this.partitions, conceptImpl.partitions)) {
                return true;
            }
            return this.superIsNotA(conceptImpl) || conceptImpl.superIsNotA(this);
        }
        return true;
    }

    private boolean intersects(Set set, Set set2) {
        if (set.size() > set2.size()) {
            return this.intersects(set2, set);
        }
        CollectionEnumeration collectionEnumeration = set.elements();
        while (collectionEnumeration.hasMoreElements()) {
            if (!set2.includes(collectionEnumeration.nextElement())) continue;
            return true;
        }
        return false;
    }

    private boolean superIsNotA(ConceptImpl conceptImpl) {
        ConceptEnumeration conceptEnumeration = this.directSupers.elements();
        while (conceptEnumeration.hasMoreElements()) {
            Concept concept = conceptEnumeration.nextConcept();
            if (!concept.isNotA(conceptImpl)) continue;
            return true;
        }
        return false;
    }

    public ConceptEnumeration extensionalSuperconcepts() {
        return new ConceptEnumeration(this.subsumedBy.elements());
    }
}

