/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.HashedSet;
import collections.UpdatableSet;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.UnificationFailure;

public class ConceptSet {
    public static final ConceptSet EMPTY = new ConceptSet();
    private UpdatableSet concepts = new HashedSet();

    public ConceptSet() {
    }

    public ConceptSet(Concept concept) {
        this.concepts.include(concept);
    }

    public ConceptEnumeration elements() {
        return new ConceptEnumeration(this.concepts.elements());
    }

    public void addConcept(Concept concept) {
        this.concepts.include(concept);
    }

    public void unite(ConceptSet conceptSet) {
        this.concepts.includeElements(conceptSet.elements());
    }

    public void joinConcept(Concept concept) throws UnificationFailure {
        HashedSet hashedSet = new HashedSet();
        ConceptEnumeration conceptEnumeration = this.elements();
        while (conceptEnumeration.hasMoreElements()) {
            Concept concept2 = conceptEnumeration.nextConcept();
            if (concept2.isa(concept)) {
                return;
            }
            if (concept2.isNotA(concept)) {
                throw new UnificationFailure();
            }
            if (concept.isa(concept2)) continue;
            hashedSet.include(concept2);
        }
        hashedSet.include(concept);
        this.concepts = hashedSet;
    }

    public void join() throws UnificationFailure {
        ConceptSet conceptSet = new ConceptSet();
        conceptSet.joinConcepts(this.elements());
        this.concepts = conceptSet.concepts;
    }

    public void joinConcepts(ConceptEnumeration conceptEnumeration) throws UnificationFailure {
        while (conceptEnumeration.hasMoreElements()) {
            this.joinConcept(conceptEnumeration.nextConcept());
        }
    }

    public void meetConcept(Concept concept) {
        HashedSet hashedSet = new HashedSet();
        ConceptEnumeration conceptEnumeration = this.elements();
        while (conceptEnumeration.hasMoreElements()) {
            Concept concept2 = conceptEnumeration.nextConcept();
            if (concept.isa(concept2)) {
                return;
            }
            if (concept2.isa(concept)) continue;
            hashedSet.include(concept2);
        }
        hashedSet.include(concept);
        this.concepts = hashedSet;
    }

    public void meet() {
        ConceptSet conceptSet = new ConceptSet();
        ConceptEnumeration conceptEnumeration = this.elements();
        while (conceptEnumeration.hasMoreElements()) {
            Concept concept = conceptEnumeration.nextConcept();
            conceptSet.meetConcept(concept);
        }
        this.concepts = conceptSet.concepts;
    }

    public boolean equals(Object object) {
        if (object instanceof ConceptSet) {
            return ((ConceptSet)object).concepts.sameStructure(this.concepts);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(123);
        ConceptEnumeration conceptEnumeration = new ConceptEnumeration(this.concepts.elements());
        int n = 1;
        while (conceptEnumeration.hasMoreElements()) {
            if (n > 1) {
                stringBuffer.append(',');
            }
            Concept concept = conceptEnumeration.nextConcept();
            stringBuffer.append(concept.getName());
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

