/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.Set;
import collections.UpdatableSet;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptEnumeration;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ConjunctiveType
implements Type {
    private UpdatableSet concepts = new HashedSet();
    private OrderedTable features = new OrderedTable();
    private boolean extensional = false;
    private boolean restricted = true;
    protected int hashCode;

    ConjunctiveType() {
        this.hashCode = 0;
    }

    public ConjunctiveType(Concept concept) {
        try {
            this.addConcept(concept);
            return;
        }
        catch (UnificationFailure unificationFailure) {
            throw new RuntimeException("***Unexpected failure in addConcept(" + concept + ").");
        }
    }

    public ConjunctiveType(ConceptSet conceptSet) throws UnificationFailure {
        ConceptEnumeration conceptEnumeration = conceptSet.elements();
        while (conceptEnumeration.hasMoreElements()) {
            this.addConcept(conceptEnumeration.nextConcept());
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public CollectionEnumeration concepts() {
        return this.concepts.elements();
    }

    public String getName() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        CollectionEnumeration collectionEnumeration = this.concepts.elements();
        int n = 1;
        while (collectionEnumeration.hasMoreElements()) {
            if (n > 1) {
                stringBuffer.append(',');
            }
            object = (Concept)collectionEnumeration.nextElement();
            stringBuffer.append(object.getName());
            ++n;
        }
        object = stringBuffer.toString();
        if (((String)object).length() == 0) {
            return "Top";
        }
        return object;
    }

    public static Type getType(Set set) throws UnificationFailure {
        if (set.isEmpty()) {
            return Type.TOP;
        }
        CollectionEnumeration collectionEnumeration = set.elements();
        ConjunctiveType conjunctiveType = new ConjunctiveType();
        while (collectionEnumeration.hasMoreElements()) {
            conjunctiveType.addConcept((Concept)collectionEnumeration.nextElement());
        }
        return conjunctiveType;
    }

    public static Type getType(String string) throws UnificationFailure, TypeException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        HashedSet hashedSet = new HashedSet();
        TypeSystem typeSystem = TypeSystem.instance();
        while (stringTokenizer.hasMoreElements()) {
            hashedSet.include(typeSystem.conceptForName(stringTokenizer.nextToken()));
        }
        return ConjunctiveType.getType(hashedSet);
    }

    public boolean isExtensional() {
        return this.extensional;
    }

    public boolean isApprop(Name name) {
        if (this.restricted) {
            return this.features.includesKey(name);
        }
        return true;
    }

    public Type appropType(Name name) {
        try {
            if (this.restricted || this.features.includesKey(name)) {
                return new ConjunctiveType((ConceptSet)this.features.at(name));
            }
            return Type.TOP;
        }
        catch (UnificationFailure unificationFailure) {
            throw new RuntimeException("***Conjunctive type for ConceptSet " + this.features.at(name) + " not defined!");
        }
    }

    public Enumeration appropFeatureNames() {
        return this.features.keys();
    }

    public boolean subsumes(Type type) {
        CollectionEnumeration collectionEnumeration = this.concepts.elements();
        block0: while (collectionEnumeration.hasMoreElements()) {
            Concept concept = (Concept)collectionEnumeration.nextElement();
            CollectionEnumeration collectionEnumeration2 = type.concepts();
            while (collectionEnumeration2.hasMoreElements()) {
                Concept concept2 = (Concept)collectionEnumeration2.nextElement();
                if (concept2.isa(concept)) continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean subsumedBy(Type type) {
        return type.subsumes(this);
    }

    public boolean canUnify(Type type) {
        CollectionEnumeration collectionEnumeration = this.concepts.elements();
        while (collectionEnumeration.hasMoreElements()) {
            Concept concept = (Concept)collectionEnumeration.nextElement();
            CollectionEnumeration collectionEnumeration2 = type.concepts();
            while (collectionEnumeration2.hasMoreElements()) {
                Concept concept2 = (Concept)collectionEnumeration2.nextElement();
                if (!concept2.isNotA(concept)) continue;
                return false;
            }
        }
        return true;
    }

    private void basicAddConcept(Concept concept) throws UnificationFailure {
        Enumeration enumeration = concept.appropFeatureNames();
        while (enumeration.hasMoreElements()) {
            Name name = (Name)enumeration.nextElement();
            ConceptSet conceptSet = concept.appropConcepts(name);
            if (this.features.includesKey(name)) {
                conceptSet.joinConcepts(((ConceptSet)this.features.at(name)).elements());
            }
            this.features.putAt(name, conceptSet);
        }
        this.extensional = this.extensional || concept.isExtensional();
        this.restricted = this.restricted && concept.isRestricted();
    }

    public void addConcept(Concept concept) throws UnificationFailure {
        this.basicAddConcept(concept);
        if (this.concepts.isEmpty()) {
            this.concepts.include(concept);
            this.hashCode += concept.hashCode();
            return;
        }
        HashedSet hashedSet = new HashedSet();
        CollectionEnumeration collectionEnumeration = this.concepts();
        while (collectionEnumeration.hasMoreElements()) {
            Concept concept2 = (Concept)collectionEnumeration.nextElement();
            ConceptSet conceptSet = concept2.unify(concept);
            hashedSet.includeElements(conceptSet.elements());
        }
        this.concepts = hashedSet;
        this.hashCode = 0;
        collectionEnumeration = this.concepts();
        while (collectionEnumeration.hasMoreElements()) {
            this.hashCode += collectionEnumeration.nextElement().hashCode();
        }
    }

    private ConjunctiveType duplicate() {
        ConjunctiveType conjunctiveType = new ConjunctiveType();
        conjunctiveType.concepts = (UpdatableSet)this.concepts.duplicate();
        conjunctiveType.features = (OrderedTable)this.features.clone();
        conjunctiveType.extensional = this.extensional;
        conjunctiveType.restricted = this.restricted;
        conjunctiveType.hashCode = this.hashCode;
        return conjunctiveType;
    }

    public Type unify(Type type) throws UnificationFailure {
        ConjunctiveType conjunctiveType = this.duplicate();
        CollectionEnumeration collectionEnumeration = type.concepts();
        while (collectionEnumeration.hasMoreElements()) {
            Concept concept = (Concept)collectionEnumeration.nextElement();
            conjunctiveType.addConcept(concept);
        }
        return conjunctiveType;
    }

    public Type mostGeneralExtensionalSupertype(Type type) {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof ConjunctiveType) {
            return ConjunctiveType.equalSet(this.concepts, ((ConjunctiveType)object).concepts);
        }
        return false;
    }

    private static boolean equalSet(Set set, Set set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        CollectionEnumeration collectionEnumeration = set.elements();
        int n = set.size();
        while (n > 0) {
            if (!set2.includes(collectionEnumeration.nextElement())) {
                return false;
            }
            --n;
        }
        return true;
    }
}

