/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.Map;
import collections.UpdatableMap;
import collections.UpdatableSet;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.JavaObjectFS;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class EquivRelation {
    private UpdatableMap tie = new HashedMap();
    private UpdatableMap eit = new HashedMap();

    public static Node unify(Node node, Node node2) throws UnificationFailure {
        EquivRelation equivRelation = new EquivRelation();
        equivRelation.unify2(node, node2);
        equivRelation.extensionalize();
        return equivRelation.rebuild(node);
    }

    public static Node unify(Node node, String string, Node node2) throws UnificationFailure {
        Node node3 = new FSNode(node.getType());
        if (EquivRelation.path(node, node3, node2, string) == node3) {
            node3 = node2;
        }
        return EquivRelation.unify(node, node3);
    }

    public static Node unify(Node node, String string, String string2) throws UnificationFailure {
        return EquivRelation.unify(node, EquivRelation.pathEquation(node, string, string2));
    }

    private static Node pathEquation(Node node, String string, String string2) throws UnificationFailure {
        FSNode fSNode = new FSNode(node.getType());
        try {
            Node node2 = EquivRelation.path(node, fSNode, null, string);
            EquivRelation.path(node, fSNode, node2, string2);
            return fSNode;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new UnificationFailure();
        }
    }

    private static Node path(Node node, Node node2, Node node3, String string) throws NoSuchElementException, UnificationFailure {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            Node node4;
            Name name = new Name(stringTokenizer.nextToken());
            if (node2.hasFeature(name)) {
                node = node.delta(name);
                node4 = node2.delta(name);
            } else {
                if (node3 != null && !stringTokenizer.hasMoreTokens()) {
                    node4 = node3;
                } else {
                    node = node.delta(name);
                    node4 = new FSNode(node.getType());
                }
                if (!(node2 instanceof FSNode)) {
                    throw new UnificationFailure();
                }
                ((FSNode)node2).addFeature(name, node4);
            }
            node2 = node4;
        }
        return node2;
    }

    public static boolean canUnify(Node node, Node node2) {
        EquivRelation equivRelation = new EquivRelation();
        try {
            equivRelation.unify2(node, node2);
            return true;
        }
        catch (UnificationFailure unificationFailure) {
            return false;
        }
    }

    private void map(Node node, Node node2) {
        Serializable serializable;
        if (node == node2) {
            return;
        }
        if (this.eit.includesKey(node)) {
            serializable = ((UpdatableSet)this.eit.at(node)).elements();
            while (serializable.hasMoreElements()) {
                Node node3 = (Node)serializable.nextElement();
                this.map(node3, node2);
            }
            this.eit.removeAt(node);
        }
        this.tie.putAt(node, node2);
        if (this.eit.includesKey(node2)) {
            serializable = (UpdatableSet)this.eit.at(node2);
        } else {
            serializable = new HashedSet();
            this.eit.putAt(node2, serializable);
        }
        serializable.include(node);
    }

    public Node getUnificator(Node node) {
        if (this.tie.includesKey(node)) {
            return (Node)this.tie.at(node);
        }
        return node;
    }

    public void unify2(Node node, Node node2) throws UnificationFailure {
        Name name;
        Enumeration enumeration;
        Object object;
        Node node3;
        Object e;
        Type type = node.getType().unify(node2.getType());
        CollectionEnumeration collectionEnumeration = type.concepts();
        if (collectionEnumeration.hasMoreElements() && (e = collectionEnumeration.nextElement()) instanceof JavaObjectFS) {
            node3 = (JavaObjectFS)e;
        } else {
            object = new HashedMap();
            enumeration = node.featureNames();
            while (enumeration.hasMoreElements()) {
                name = (Name)enumeration.nextElement();
                object.putAt(name, node.delta(name));
            }
            enumeration = node2.featureNames();
            while (enumeration.hasMoreElements()) {
                name = (Name)enumeration.nextElement();
                object.putAt(name, node2.delta(name));
            }
            node3 = new FSNode(type, (Map)object);
        }
        this.map(node, node3);
        this.map(node2, node3);
        enumeration = node.featureNames();
        while (enumeration.hasMoreElements()) {
            Node node4;
            name = (Name)enumeration.nextElement();
            if (!node2.hasFeature(name) || (object = this.getUnificator(node.delta(name))) == (node4 = this.getUnificator(node2.delta(name)))) continue;
            this.unify2((Node)object, node4);
        }
    }

    public void extensionalize() throws UnificationFailure {
    }

    public Node rebuild(Node node) {
        boolean bl;
        Node node2;
        if (this.tie.includesKey(node)) {
            node2 = (Node)this.tie.at(node);
            bl = this.eit.includesKey(node2);
            if (bl) {
                this.eit.removeAt(node2);
            }
        } else {
            node2 = node.duplicate();
            this.tie.putAt(node, node2);
            bl = true;
        }
        if (bl) {
            Enumeration enumeration = node2.featureNames();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                node2.updateFeature(name, this.rebuild(node2.delta(name)));
            }
        }
        return node2;
    }
}

