/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.Map;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.OrderedTable;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FSNode
implements Node {
    Type nodetype;
    private OrderedTable feats;
    private static int counter;
    public final int seqNo = ++counter;

    public FSNode(Type type, Map map) throws TypeException {
        this.nodetype = type;
        this.feats = new OrderedTable(type.appropFeatureNames());
        CollectionEnumeration collectionEnumeration = map.keys();
        while (collectionEnumeration.hasMoreElements()) {
            Name name = (Name)collectionEnumeration.nextElement();
            this.addFeature(name, (Node)map.at(name));
        }
    }

    public FSNode(Type type) {
        this.nodetype = type;
        this.feats = new OrderedTable(type.appropFeatureNames());
    }

    public FSNode() {
        this(TypeSystem.any());
    }

    public FSNode(String string) throws UnificationFailure {
        this(ConjunctiveType.getType(string));
    }

    public FSNode(String string, OrderedTable orderedTable) throws UnificationFailure, TypeException {
        this(ConjunctiveType.getType(string), orderedTable);
    }

    FSNode(Type type, OrderedTable orderedTable) {
        this.nodetype = type;
        this.feats = orderedTable;
    }

    public Type getType() {
        return this.nodetype;
    }

    public void refine(Type type) throws UnificationFailure {
        this.nodetype = this.nodetype.unify(type);
    }

    public Enumeration featureNames() {
        return this.feats.keys();
    }

    public boolean hasFeature(Name name) {
        return this.feats.includesKey(name);
    }

    public Node delta(Name name) throws NoSuchElementException {
        return (Node)this.feats.at(name);
    }

    public Node at(String string) throws NoSuchElementException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        Node node = this;
        while (stringTokenizer.hasMoreTokens()) {
            node = node.delta(new Name(stringTokenizer.nextToken()));
        }
        return node;
    }

    public void updateFeature(Name name, Node node) {
        if (!this.hasFeature(name)) {
            throw new RuntimeException("Feature " + name + " updated but non-existent!");
        }
        this.feats.putAt(name, node);
    }

    public FSNode addFeature(String string, Node node) throws TypeException {
        return this.addFeature(new Name(string), node);
    }

    public FSNode addFeature(Name name, Node node) throws TypeException {
        if (this.hasFeature(name)) {
            throw new RuntimeException("Feature " + name.toString() + " redefined!");
        }
        if (this.nodetype.isApprop(name) && this.nodetype.appropType(name).subsumes(node.getType())) {
            this.feats.putAt(name, node);
            return this;
        }
        System.err.println("Ou-Ha! feature: " + name + ", isApprop: " + this.nodetype.isApprop(name) + ", appropType: " + this.nodetype.appropType(name) + ", nodetype: " + this.nodetype + " (+" + this.nodetype.hashCode() + "), class: " + this.nodetype.getClass());
        throw new TypeException();
    }

    public void totallyWellType() {
        Enumeration enumeration = this.nodetype.appropFeatureNames();
        while (enumeration.hasMoreElements()) {
            Name name = (Name)enumeration.nextElement();
            if (this.hasFeature(name)) continue;
            this.feats.putAt(name, new FSNode(this.nodetype.appropType(name)));
        }
    }

    public Node duplicate() {
        return new FSNode(this.nodetype, (OrderedTable)this.feats.clone());
    }
}

