/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.FSNode;
import de.uni_hamburg.fs.JavaObjectFS;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.PrettyPrinter;
import de.uni_hamburg.fs.Subsumption;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FeatureStructure {
    private static int counter;
    public final int seqNo = ++counter;
    private Node node;
    protected int hashCode;

    public FeatureStructure(Node node) {
        this.node = node;
        this.hashCode = node.getType().hashCode();
        Enumeration enumeration = node.featureNames();
        while (enumeration.hasMoreElements()) {
            this.hashCode += enumeration.nextElement().hashCode();
        }
    }

    public FeatureStructure(Type type) {
        this(new FSNode(type));
    }

    public Type getType() {
        return this.node.getType();
    }

    public Node getRoot() {
        return this.node;
    }

    public Object getJavaObject() {
        return ((JavaObjectFS)this.node).getJavaObject();
    }

    public Type getType(String string) throws NoSuchElementException {
        return this.node.at(string).getType();
    }

    public boolean subsumes(FeatureStructure featureStructure) {
        return Subsumption.subsumes(this.node, featureStructure.node);
    }

    public boolean subsumedBy(FeatureStructure featureStructure) {
        return featureStructure.subsumes(this);
    }

    public FeatureStructure unify(FeatureStructure featureStructure) throws UnificationFailure {
        return new FeatureStructure(EquivRelation.unify(this.node, featureStructure.node));
    }

    public FeatureStructure unify(FeatureStructure featureStructure, String string) throws UnificationFailure {
        return new FeatureStructure(EquivRelation.unify(this.node, string, featureStructure.node));
    }

    public FeatureStructure equate(String string, String string2) throws UnificationFailure {
        return new FeatureStructure(EquivRelation.unify(this.node, string, string2));
    }

    public boolean canUnify(FeatureStructure featureStructure) {
        return EquivRelation.canUnify(this.node, featureStructure.node);
    }

    public Enumeration featureNames() {
        return this.node.featureNames();
    }

    public boolean hasFeature(String string) {
        return this.node.hasFeature(new Name(string));
    }

    public boolean hasFeature(Name name) {
        return this.node.hasFeature(name);
    }

    public FeatureStructure at(String string) throws NoSuchElementException {
        return new FeatureStructure(this.node.at(string));
    }

    public Object unpackingAt(String string) throws NoSuchElementException {
        Node node = this.node.at(string);
        if (node instanceof JavaObjectFS) {
            return ((JavaObjectFS)node).getJavaObject();
        }
        return new FeatureStructure(node);
    }

    public FeatureStructure change(String string, FeatureStructure featureStructure) {
        Name name = new Name(string);
        FSNode fSNode = (FSNode)this.node.duplicate();
        fSNode.updateFeature(name, featureStructure.node);
        return new FeatureStructure(fSNode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FeatureStructure) {
            return this.subsumes((FeatureStructure)object) && ((FeatureStructure)object).subsumes(this);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return PrettyPrinter.toString(this);
    }
}

