/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.renew.util.Types;
import de.renew.util.Value;
import de.uni_hamburg.fs.Bound;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.SimpleConcept;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class JavaObjectFS
extends SimpleConcept
implements Node {
    private Object javaObject;
    private JavaConcept concept;
    private Type type;

    public JavaObjectFS(Object object) {
        this.javaObject = object;
        Class clazz = object instanceof Value ? Types.typify(((Value)object).value.getClass()) : object.getClass();
        this.concept = TypeSystem.instance().getJavaConcept(clazz);
        this.type = new ConjunctiveType(this);
    }

    public Object getJavaObject() {
        return this.javaObject;
    }

    public int hashCode() {
        return this.javaObject.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof JavaObjectFS) {
            return this.javaObject.equals(((JavaObjectFS)object).javaObject);
        }
        return this.javaObject.equals(object);
    }

    public Enumeration featureNames() {
        return SimpleConcept.emptySet.elements();
    }

    public boolean hasFeature(Name name) {
        return false;
    }

    public Node delta(Name name) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public Node at(String string) throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    public void updateFeature(Name name, Node node) {
    }

    public String getName() {
        if (this.javaObject instanceof String) {
            return String.valueOf('\"') + this.javaObject.toString() + '\"';
        }
        return this.javaObject.toString();
    }

    public boolean isa(Concept concept) {
        if (concept instanceof JavaObjectFS) {
            Object object = ((JavaObjectFS)concept).getJavaObject();
            return this.javaObject.equals(object);
        }
        if (concept instanceof Bound) {
            return ((Bound)concept).subsumesObject(this.javaObject);
        }
        return this.concept.isa(concept);
    }

    public boolean isNotA(Concept concept) {
        return !this.isa(concept);
    }

    public Type getType() {
        return this.type;
    }

    public Node duplicate() {
        return this;
    }
}

