/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedSet;
import collections.UpdatableSet;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.TypeException;
import java.util.Enumeration;

public class Partition {
    private UpdatableSet concepts = new HashedSet();

    public Partition() {
    }

    public Partition(ConceptImpl conceptImpl) {
        this.concepts.include(conceptImpl);
        conceptImpl.partitions.include(this);
    }

    public void union(Partition partition) throws TypeException {
        Enumeration enumeration = partition.concepts();
        while (enumeration.hasMoreElements()) {
            ConceptImpl conceptImpl = (ConceptImpl)enumeration.nextElement();
            this.addConcept(conceptImpl);
        }
    }

    public void addConcept(ConceptImpl conceptImpl) throws TypeException {
        CollectionEnumeration collectionEnumeration = this.concepts.elements();
        while (collectionEnumeration.hasMoreElements()) {
            ConceptImpl conceptImpl2 = (ConceptImpl)collectionEnumeration.nextElement();
            if (conceptImpl2 == conceptImpl) {
                return;
            }
            if (!conceptImpl2.isa(conceptImpl) && !conceptImpl.isa(conceptImpl2)) continue;
            throw new TypeException();
        }
        this.concepts.include(conceptImpl);
        conceptImpl.partitions.include(this);
    }

    public boolean containsConcept(ConceptImpl conceptImpl) {
        return this.concepts.includes(conceptImpl);
    }

    public Enumeration concepts() {
        return this.concepts.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        CollectionEnumeration collectionEnumeration = this.concepts.elements();
        int n = 1;
        while (collectionEnumeration.hasMoreElements()) {
            if (n > 1) {
                stringBuffer.append(',');
            }
            ConceptImpl conceptImpl = (ConceptImpl)collectionEnumeration.nextElement();
            stringBuffer.append(conceptImpl.getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof Partition) {
            return ((Partition)object).concepts.sameStructure(this.concepts);
        }
        return false;
    }
}

