/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.JavaObjectFS;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.TagMap;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import java.util.Enumeration;

public class PrettyPrinter {
    private TagMap map;

    public static void println(FeatureStructure featureStructure) {
        System.out.println(PrettyPrinter.toString(featureStructure));
    }

    public static String toString(FeatureStructure featureStructure) {
        Node node = featureStructure.getRoot();
        return "\n" + new PrettyPrinter(node).toString(node, "\n ", Type.TOP) + "\n";
    }

    private PrettyPrinter(Node node) {
        this.map = new TagMap(node);
    }

    private String toString(Node node, String string, Type type) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.map.getTag(node);
        if (n != 0) {
            stringBuffer = stringBuffer.append("#").append(Math.abs(n));
            string = String.valueOf(string) + PrettyPrinter.indent(stringBuffer.length());
        }
        if (!this.map.isVisited(node)) {
            this.map.setVisited(node);
            stringBuffer.append(this.untaggedToString(node, string, type));
        }
        return stringBuffer.toString();
    }

    private String listToString(Node node, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (TypeSystem.neList().subsumes(node.getType())) {
            Node node2;
            int n;
            stringBuffer = node.hasFeature(TypeSystem.HEAD_FEATURE) ? stringBuffer.append(this.toString(node.delta(TypeSystem.HEAD_FEATURE), String.valueOf(string) + " ", Type.TOP)).append(string) : stringBuffer.append("(no head feature!)");
            stringBuffer = node.hasFeature(TypeSystem.TAIL_FEATURE) ? ((n = this.map.getTag(node2 = node.delta(TypeSystem.TAIL_FEATURE))) != 0 && !TypeSystem.eList().equals(node2.getType()) ? stringBuffer.append("| ").append(this.toString(node2, String.valueOf(string) + "   ", TypeSystem.list())) : stringBuffer.append(this.listToString(node2, string))) : stringBuffer.append("(no tail feature!)");
        } else if (!TypeSystem.eList().equals(node.getType())) {
            stringBuffer.append("| ").append(this.toString(node, String.valueOf(string) + "   ", Type.TOP));
        }
        return stringBuffer.toString();
    }

    private String innerToString(Node node, String string, Type type) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (!node.getType().equals(type)) {
            stringBuffer = stringBuffer.append(node.getType().getName());
            string2 = string;
        }
        Enumeration enumeration = node.featureNames();
        while (enumeration.hasMoreElements()) {
            Name name = (Name)enumeration.nextElement();
            String string3 = name.toString();
            stringBuffer = stringBuffer.append(string2).append(string3).append(": ").append(this.toString(node.delta(name), String.valueOf(string) + PrettyPrinter.indent(3 + string3.length()), node.getType().appropType(name)));
            string2 = string;
        }
        return stringBuffer.toString();
    }

    public String untaggedToString(Node node, String string, Type type) {
        StringBuffer stringBuffer = new StringBuffer();
        if (node instanceof JavaObjectFS) {
            stringBuffer.append('(').append(((JavaObjectFS)node).getName()).append(')');
        } else if (TypeSystem.neList().subsumes(node.getType()) || TypeSystem.eList().equals(node.getType())) {
            stringBuffer = stringBuffer.append("<").append(this.listToString(node, string)).append(">");
        } else {
            stringBuffer.append("[").append(this.innerToString(node, string, type)).append("]");
        }
        return stringBuffer.toString();
    }

    public static final String indent(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }
}

