/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.Map;
import collections.UpdatableMap;
import collections.UpdatableSet;
import de.uni_hamburg.fs.EquivRelation;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Node;
import java.util.Enumeration;

public class TagMap {
    private UpdatableMap tagmap = new HashedMap();
    private UpdatableSet visited = new HashedSet();
    private Node root;

    public TagMap(Node node) {
        this.root = node;
        this.buildTagMap(this.root, 0);
    }

    public TagMap(Node node, EquivRelation equivRelation, Map map) {
        this.root = node;
        CollectionEnumeration collectionEnumeration = map.keys();
        while (collectionEnumeration.hasMoreElements()) {
            Integer n = (Integer)collectionEnumeration.nextElement();
            Node node2 = equivRelation.getUnificator((Node)map.at(n));
            this.tagmap.putAt(node2, n);
        }
    }

    public Node getRoot() {
        return this.root;
    }

    private int buildTagMap(Node node, int n) {
        if (this.tagmap.includesKey(node)) {
            int n2 = (Integer)this.tagmap.at(node);
            if (n2 == 0) {
                this.tagmap.putAt(node, new Integer(++n));
            }
        } else {
            this.tagmap.putAt(node, new Integer(0));
            Enumeration enumeration = node.featureNames();
            while (enumeration.hasMoreElements()) {
                Name name = (Name)enumeration.nextElement();
                n = this.buildTagMap(node.delta(name), n);
            }
        }
        return n;
    }

    public void resetVisited() {
        this.visited = new HashedSet();
    }

    public static final String indent(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public int getTag(Node node) {
        if (this.tagmap.includesKey(node)) {
            return (Integer)this.tagmap.at(node);
        }
        return 0;
    }

    public boolean isVisited(Node node) {
        return this.visited.includes(node);
    }

    public void setVisited(Node node) {
        this.visited.include(node);
    }
}

