/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.HashedMap;
import collections.HashedSet;
import collections.UpdatableMap;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptImpl;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.JavaConcept;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.Partition;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeException;
import java.util.NoSuchElementException;

public class TypeSystem {
    public static final Name ANY = new Name("Any");
    public static final Name LIST = new Name("List");
    public static final Name NELIST = new Name("NEList");
    public static final Name ELIST = new Name("EList");
    public static final Name HEAD_FEATURE = new Name("hd");
    public static final Name TAIL_FEATURE = new Name("tl");
    private Type tObject;
    private Type tAny;
    private Type tList;
    private Type tEList;
    private Type tNEList;
    private static String[] imported = new String[]{"", "java.lang."};
    private static TypeSystem _instance = null;
    private ConceptImpl root = new ConceptImpl();
    private UpdatableMap concepts = new HashedMap();

    public TypeSystem() {
        System.out.println("New TypeSystem.");
    }

    private void init() {
        this.getJavaConcept(Boolean.TYPE);
        this.getJavaConcept(Byte.TYPE);
        this.getJavaConcept(Character.TYPE);
        this.getJavaConcept(Short.TYPE);
        this.getJavaConcept(Integer.TYPE);
        this.getJavaConcept(Long.TYPE);
        this.getJavaConcept(Float.TYPE);
        this.getJavaConcept(Double.TYPE);
        try {
            this.tObject = new ConjunctiveType(this.conceptForName("java.lang.Object"));
            new ConceptImpl(ANY.toString(), false, false);
            ConceptImpl conceptImpl = new ConceptImpl(LIST.toString(), false, true);
            ConceptImpl conceptImpl2 = new ConceptImpl(ELIST.toString(), true, true);
            conceptImpl2.basicAddIsa(conceptImpl);
            ConceptImpl conceptImpl3 = new ConceptImpl(NELIST.toString(), false, true);
            conceptImpl3.addApprop(HEAD_FEATURE, new ConceptSet());
            conceptImpl3.addApprop(TAIL_FEATURE, new ConceptSet(conceptImpl));
            conceptImpl3.basicAddIsa(conceptImpl);
            new Partition(conceptImpl2).addConcept(conceptImpl3);
        }
        catch (TypeException typeException) {
            System.err.println("Exception during TypeSystem init:");
            typeException.printStackTrace();
        }
        this.transitiveClosure();
    }

    public void transitiveClosure() {
        this.root.transitiveClosure();
    }

    public void recalcDirectIsa() throws TypeException {
        this.root.transitiveClosure();
        this.root.recalcDirectIsa(new HashedSet());
    }

    public void inheritFeatures() throws TypeException {
        this.recalcDirectIsa();
        this.root.inherit(new HashedSet());
        this.root.buildFeatureTypes(new HashedSet());
        this.tAny = new ConjunctiveType(this.conceptForName(ANY));
        this.tList = new ConjunctiveType(this.conceptForName(LIST));
        this.tEList = new ConjunctiveType(this.conceptForName(ELIST));
        this.tNEList = new ConjunctiveType(this.conceptForName(NELIST));
    }

    public Type tObject() {
        return this.tObject;
    }

    public Type tAny() {
        return this.tAny;
    }

    public Type tList() {
        return this.tList;
    }

    public Type tEList() {
        return this.tEList;
    }

    public Type tNEList() {
        return this.tNEList;
    }

    public static TypeSystem instance() {
        if (_instance == null) {
            return TypeSystem.newInstance();
        }
        return _instance;
    }

    public static TypeSystem newInstance() {
        _instance = new TypeSystem();
        _instance.init();
        return _instance;
    }

    public static void setInstance(TypeSystem typeSystem) {
        _instance = typeSystem;
    }

    public static Type object() {
        return TypeSystem._instance.tObject;
    }

    public static Type any() {
        return TypeSystem._instance.tAny;
    }

    public static Type list() {
        return TypeSystem._instance.tList;
    }

    public static Type eList() {
        return TypeSystem._instance.tEList;
    }

    public static Type neList() {
        return TypeSystem._instance.tNEList;
    }

    public void addConcept(Concept concept) {
        if (concept instanceof ConceptImpl) {
            ((ConceptImpl)concept).basicAddIsa(this.root);
        }
        this.concepts.putAt(new Name(concept.getName()), concept);
    }

    public void removeConcept(Concept concept) {
        this.concepts.removeAt(concept.getName());
    }

    public boolean hasConcept(String string) {
        return this.hasConcept(new Name(string));
    }

    public boolean hasConcept(Name name) {
        if (this.concepts.includesKey(name)) {
            return true;
        }
        try {
            this.getJavaClass(name.toString());
            return true;
        }
        catch (TypeException typeException) {
            return false;
        }
    }

    public Concept conceptForName(String string) {
        return this.conceptForName(new Name(string));
    }

    public Concept conceptForName(Name name) {
        Concept concept = null;
        try {
            concept = (Concept)this.concepts.at(name);
        }
        catch (NoSuchElementException noSuchElementException) {
            try {
                concept = this.getJavaConcept(this.getJavaClass(name.toString()));
            }
            catch (TypeException typeException) {
                System.out.println("Automatically creating new concept " + name);
                concept = new ConceptImpl(name.toString(), false, true);
            }
        }
        return concept;
    }

    public JavaConcept getJavaConcept(Class clazz) {
        String string = clazz.getName();
        if (this.concepts.includesKey(string)) {
            return (JavaConcept)this.concepts.at(string);
        }
        JavaConcept javaConcept = new JavaConcept(clazz);
        this.addConcept(javaConcept);
        return javaConcept;
    }

    public Class getJavaClass(String string) throws TypeException {
        int n = imported.length;
        if (string.indexOf(46) >= 0) {
            n = 1;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                return Class.forName(String.valueOf(imported[n2]) + string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
            ++n2;
        }
        throw new TypeException();
    }
}

