/*  ---------------------------------------------------------------------------------
 *  Install Renew 1.2 for OS/2 Rexx
 *
 *  Nov. 1999   F. Wienberg
 *  --------------------------------------------------------------------------------- */

/* New: InstallRenew.cmd now takes a parameter for the TCP/IP port
 * on which Renew can set up a "Drawing Load Server".
 * 
 * The installation routine then creates a program object called
 * "load into Renew", which is associated with "*.RNW" files and
 * invokes the Rexx program "loadrenew.cmd".
 * Thus a drawing can be loaded into an already running Renew just
 * by double-clicking it!
 *
 * Syntax: InstallRenew <port>
 *
 * see also: loadrenew.cmd
 */

signal on halt name SignalHandler       /* Exception handler */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse upper value directory() with InstallDir "\BIN\OS2"

if (\ (CHARIN(InstallDir"\bin\os2\InstallRenew.cmd")='/'))
  then
  do
     say "please change to the directory InstallRenew.cmd is located in!"
     exit
  end

say "Installing to "InstallDir

say "Generating Command File..."

FileName = SysSearchPath('PATH', 'javapm.exe')
if FileName = '' then
do
   say 'Error: Cannot find javapm.exe in PATH directories.'
   exit
end

parse upper value FileName with JavaPath "BIN\JAVAPM.EXE"

say "Java found in "JavaPath

MYCLASSPATH = InstallDir"\renew.jar;"InstallDir";."

say "Renew will add "MYCLASSPATH" to your CLASSPATH."

port=ARG(1)

say "Constructing renew.cmd..."

if (port="") then
   serversetup=""
else
   serversetup=" -Dde.renew.loadServerPort="port

APPL="pm -cons"serversetup" de.renew.gui.CPNApplication"
FILE="renew"
call MakeCmdFile

APPL="pm -cons"serversetup" -Dde.renew.mode=de.renew.gui.SequentialJavaMode de.renew.gui.CPNApplication"
FILE="srenew"
call MakeCmdFile

APPL=" de.renew.call.StubGenerator"
FILE="makestub"
call MakeCmdFile

APPL=" de.renew.call.StubCompiler"
FILE="compilestub"
call MakeCmdFile

say "Removing old Renew 1.2 Folder (if any)..."
rc=SysDestroyObject('<Renew1_2Folder>')

say "Creating Renew 1.2 folder on Desktop..."
DEST='<WP_DESKTOP>'
if ( SysCreateObject( 'WPFolder',,
                 'Renew 1.2', DEST,,
                 'OBJECTID=<Renew1_2Folder>;ICONFILE='InstallDir'\bin\os2\RenewFolder;ANIMATEDFILE='InstallDir'\bin\os2\RenewFolderOpen',,
                  'f' ) != 1 ) then do
    say 'Error: Renew folder object could not be created on Desktop (error code 'rc')'
    exit
end

say 'Renew folder has been created!'

if (port<>"") then
do
  say "Creating Drawing Loader Program Object..."

  param = port" %*"

  rc=SysCreateObject('WPProgram',,
                   'load into Renew','<Renew1_2Folder>',,
                   'OBJECTID=<RenewDrawingLoader1_2>;STARTUPDIR='InstallDir'\samples;ASSOCFILTER=*.RNW;ASSOCTYPE=Renew Drawing;EXENAME='InstallDir'\bin\os2\loadrenew.cmd;PARAMETERS='param';MINIMIZED=YES',,
                   'u')

  if (rc)
    then do
      say 'Drawing Loader Program Object has been created!'
      /* Icon can only be set after creation: */
      rc=SysSetObjectData('<RenewDrawingLoader1_2>','ICONFILE='InstallDir'\bin\os2\RENEW.ICO');
    end
  else
    say 'Error: Drawing Loader program object could not be created (error code 'rc')'

end

say "Creating Renew Program Object..."

rc=SysCreateObject('WPProgram',,
                   'Renew 1.2','<Renew1_2Folder>',,
                   'OBJECTID=<Renew1_2>;STARTUPDIR='InstallDir'\samples;ASSOCFILTER=*.RNW;ASSOCTYPE=Renew Drawing;EXENAME='InstallDir'\bin\os2\renew.cmd;' ,,
                   'u')

if (rc)
  then
  say 'Renew Program Object has been created!'
else
  say 'Error: Renew program object could not be created (error code 'rc')'


say "Creating Sequential Renew Program Object..."

rc=SysCreateObject('WPProgram',,
                   'Sequential Renew 1.2','<Renew1_2Folder>',,
                   'OBJECTID=<SRenew1_2>;STARTUPDIR='InstallDir'\samples;ASSOCFILTER=*.RNW;ASSOCTYPE=Renew Drawing;ICONFILE='InstallDir'\bin\os2\RENEW.ICO;EXENAME='InstallDir'\bin\os2\srenew.cmd;' ,,
                   'u')

if (rc)
  then
  say 'Sequential Renew Program Object has been created!'
else
  say 'Error: Sequential Renew Program Object could not be created (error code 'rc')'


say "Creating Renew Stub Compiler Program Object..."

rc=SysCreateObject('WPProgram',,
                   'compile Renew Stub','<Renew1_2Folder>',,
                   'OBJECTID=<StubCompiler1_2>;STARTUPDIR='InstallDir'\samples;ASSOCFILTER=*.STUB;ASSOCTYPE=Renew Stub;EXENAME='InstallDir'\bin\os2\compilestub.cmd;' ,,
                   'u')

if (rc)
  then
  say 'Renew Stub Compiler Program Object has been created!'
else
  say 'Error: Renew Stub Compiler Program Object could not be created (error code 'rc')'


say "Creating Renew User Guide Object..."
if (SysCreateShadow(InstallDir'\doc\renew.pdf','<Renew1_2Folder>'))
  then
  say 'Renew User Guide Object has been created!'
else
  say 'Error: Renew User Guide Object could not be created (error code 'rc')'

say "Creating Renew Sample Folder Object..."
if (SysCreateShadow(InstallDir'\samples','<Renew1_2Folder>'))
  then
  say 'Renew Sample Folder Object has been created!'
else
  say 'Error: Renew Sample Folder Object could not be created (error code 'rc')'

say "Done. Press Return."

pull

exit

SignalHandler:
  call SysCls
  Say ;
  Say "error - exiting..."
  exit

MakeCmdFile:
"@echo @ECHO OFF > "FILE".cmd"
"@echo REM Renew 1.2 OS/2 Batch Command File >> "FILE".cmd"
"@echo REM By F. Wienberg and O. Kummer, 11/1999 >> "FILE".cmd"
'@echo IF "%%CLASSPATH%%" == "" GOTO NOCP >> 'FILE".cmd"
"@echo SET CLASSPATH=%%CLASSPATH%%;"MYCLASSPATH" >> "FILE".cmd"
"@echo GOTO START >> "FILE".cmd"
"@echo :NOCP >> "FILE".cmd"
"@echo SET CLASSPATH="MYCLASSPATH" >> "FILE".cmd"
"@echo :START >> "FILE".cmd"
"@echo java"APPL" %%1 %%2 %%3 %%4 %%5 %%6 %%7 %%8 %%9 >> "FILE".cmd"
return
