package samples.reisig;

import de.renew.unify.Tuple;
import de.renew.util.Value;

public abstract class Topology {
  // Methods that determine the topology.
  public abstract int[] nodes();
  public abstract int[] neighbors(int i);

  // Convenience methods.
  public Tuple[] r(int i) {
    return prod(i,neighbors(i));
  }

  public Tuple[] all() {
    int cnt=0;
    int[] nodes=nodes();
    for (int i=0;i<nodes.length;i++) {
      cnt=cnt+neighbors(i).length;
    }
    Tuple[] result=new Tuple[cnt];
    cnt=0;
    for (int i=0;i<nodes.length;i++) {
      int[] n=neighbors(i);
      for (int j=0;j<n.length;j++) {
	result[cnt++]=makePair(i,n[j]);
      }
    }
    return result;
  }

  public static Tuple makePair(int x,int y) {
    Object[] arr=new Object[2];
    arr[0]=new Value(new Integer(x));
    arr[1]=new Value(new Integer(y));
    return new Tuple(arr,null);
  }

  public void sort(int[] x) {
    for (int i=x.length-1;i>0;i--) {
      for (int j=0;j<i;j++) {
	if (x[i]<x[j]) {
	  int h=x[i];x[i]=x[j];x[j]=h;
	}
      }
    }
  }

  public int[] union(int[] x,int[] y) {
    x=(int[])x.clone();
    y=(int[])y.clone();

    sort(x);
    sort(y);
    int[] temp=new int[x.length+y.length];
    int i=0;
    int j=0;
    int k=0;
    while (i<x.length || j<y.length) {
      int t;
      if (i==x.length || (j!=y.length && x[i]>y[j])) {
	t=y[j++];
      } else {
	t=x[i++];
      }
      if (k==0 || t>temp[k-1]) {
	temp[k++]=t;
      }
    }
    int[] result=new int[k];
    for (i=0;i<k;i++) {
      result[i]=temp[i];
    }
    return result;
  }
  
  // Cartesian product
  public static Tuple[] cart(int[] x,int[] y) {
    Tuple[] result=new Tuple[x.length*y.length];
    for (int i=0;i<x.length;i++) {
      for (int j=0;j<x.length;j++) {
	result[i]=makePair(x[i],y[j]);
      }
    }
    return result;
  }

  // Vector product
  public static Tuple[] prod(int[] x,int y) {
    Tuple[] result=new Tuple[x.length];
    for (int i=0;i<x.length;i++) {
      result[i]=makePair(x[i],y);
    }
    return result;
  }

  public static Tuple[] prod(int x,int y[]) {
    Tuple[] result=new Tuple[y.length];
    for (int i=0;i<y.length;i++) {
      result[i]=makePair(x,y[i]);
    }
    return result;
  }

  public static Tuple[] prod(int[] x,int[] y) {
    Tuple[] result=new Tuple[x.length];
    for (int i=0;i<x.length;i++) {
      result[i]=makePair(x[i],y[i]);
    }
    return result;
  }

  public static Tuple[] pairs(int[] x) {
    return prod(x,x);
  }
}
