/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import de.renew.gui.ResponseDocument;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.command.CLCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class GuiPromptPlugin
extends PluginAdapter {
    public static Logger logger = Logger.getLogger(GuiPromptPlugin.class);
    JMenuItem _menu;
    PromptDialog _promptDialog;

    public GuiPromptPlugin(URL uRL) throws PluginException {
        super(uRL);
    }

    public GuiPromptPlugin(PluginProperties pluginProperties) {
        super(pluginProperties);
    }

    public void init() {
        this._menu = this.createMenu();
        DrawPlugin.getCurrent().getMenuManager().registerMenu("Plugins", this._menu);
        PluginManager.getInstance().addCLCommand("guiprompt", (CLCommand)new GuiPromptCommand());
    }

    public boolean cleanup() {
        PluginManager.getInstance().removeCLCommand("guiprompt");
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin != null) {
            drawPlugin.getMenuManager().unregisterMenu(this._menu);
        }
        if (this._promptDialog != null) {
            this._promptDialog.dispose();
            this._promptDialog = null;
        }
        return true;
    }

    private JMenuItem createMenu() {
        JMenuItem jMenuItem = new JMenuItem("Show Gui prompt...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GuiPromptPlugin.this.showPromptDialog();
            }
        });
        jMenuItem.putClientProperty("ch.ifa.draw.menu.id", this.getProperties().getProperty("requires"));
        return jMenuItem;
    }

    private void showPromptDialog() {
        if (this._promptDialog == null) {
            this._promptDialog = new PromptDialog();
        }
        this._promptDialog.show();
    }

    private class GuiPromptCommand
    implements CLCommand {
        private GuiPromptCommand() {
        }

        public String getDescription() {
            return "Opens a window where commands can be executed.";
        }

        public void execute(String[] stringArray, final PrintStream printStream) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        GuiPromptPlugin.this.showPromptDialog();
                        printStream.println("Prompt dialog now visible.");
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                printStream.println("Exception while showing prompt dialog: " + invocationTargetException.getTargetException());
                logger.error((Object)invocationTargetException.getTargetException().toString(), (Throwable)invocationTargetException);
            }
        }
    }

    private class PromptDialog
    extends JFrame {
        JTextField _inputField;
        private JEditorPane _responseArea;
        private PrintStream _responseStream;
        private ResponseDocument _responseDocument;

        public PromptDialog() {
            super("Command Input");
            this._inputField = new JTextField(30);
            JButton jButton = new JButton("execute");
            JButton jButton2 = new JButton("clear");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PromptDialog.this.executeCommand();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PromptDialog.this.clearFields();
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(this._inputField);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            this._responseArea = new JEditorPane();
            this._responseArea.setEditable(false);
            this.setupResponseDocument();
            JRootPane jRootPane = this.getRootPane();
            jRootPane.setLayout(new BorderLayout());
            jRootPane.add((Component)jPanel, "North");
            jRootPane.add((Component)new JScrollPane(this._responseArea), "Center");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    logger.debug((Object)"window closing.");
                    PromptDialog.this._responseStream.close();
                    if (PromptDialog.this._responseDocument != null) {
                        PromptDialog.this._responseDocument.terminate();
                        PromptDialog.this._responseDocument = null;
                    }
                    GuiPromptPlugin.this._promptDialog = null;
                    PromptDialog.this._responseStream = null;
                    PromptDialog.this.dispose();
                }
            });
            this._inputField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        PromptDialog.this.executeCommand();
                    }
                }
            });
            this.pack();
        }

        private void executeCommand() {
            try {
                String string = this._inputField.getText();
                Map map = PluginManager.getInstance().getCLCommands();
                String[] stringArray = this.splitString(string);
                if (stringArray.length == 0) {
                    return;
                }
                final CLCommand cLCommand = (CLCommand)map.get(stringArray[0]);
                if (cLCommand == null) {
                    this._responseStream.println("unknown command: " + stringArray[0]);
                } else {
                    final String[] stringArray2 = new String[stringArray.length - 1];
                    for (int i = 0; i < stringArray2.length; ++i) {
                        stringArray2[i] = stringArray[i + 1];
                    }
                    logger.debug((Object)("GuiPrompt: scheduling command: " + string));
                    this._responseStream.println(">" + string);
                    new Thread(){

                        public void run() {
                            PromptDialog.this._responseDocument.revive();
                            cLCommand.execute(stringArray2, PromptDialog.this._responseStream);
                        }
                    }.start();
                }
            }
            catch (RuntimeException runtimeException) {
                this._responseStream.println("GuiPrompt: an exeption occurred: " + runtimeException);
                logger.error((Object)runtimeException.getMessage(), (Throwable)runtimeException);
            }
        }

        private String[] splitString(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            return stringArray;
        }

        private void clearFields() {
            this._inputField.setText("");
            this.setupResponseDocument();
        }

        private void setupResponseDocument() {
            try {
                PipedOutputStream pipedOutputStream = new PipedOutputStream();
                this._responseStream = new PrintStream(pipedOutputStream, true);
                this._responseDocument = new ResponseDocument(pipedOutputStream);
                this._responseArea.setDocument(this._responseDocument);
                this._responseStream.println("Execution feedback:\n");
            }
            catch (IOException iOException) {
                this._responseDocument = null;
                this._responseStream = System.out;
                this._responseArea.setDocument(this._responseArea.getEditorKit().createDefaultDocument());
                this._responseArea.setText("Feedback stream could not be established: " + iOException.toString() + "\nFallback to console output.");
                logger.error((Object)iOException.toString(), (Throwable)iOException);
            }
        }

        public void show() {
            super.show();
            GuiPromptPlugin.this.registerExitBlock();
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame("Tools", (Frame)this);
        }

        public void dispose() {
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)this);
            GuiPromptPlugin.this.registerExitOk();
            super.dispose();
        }
    }
}

