/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ant;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.util.Iconkit;
import de.renew.ant.AntTaskLogAppender;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractExportTask
extends Task {
    private final ExportFormat exportFormat;
    private final String defaultExtension;
    private File destdir = null;
    private Vector<FileSet> filesets = new Vector();

    protected AbstractExportTask(ExportFormat exportFormat) {
        this.exportFormat = exportFormat;
        FileFilter fileFilter = exportFormat.fileFilter();
        this.defaultExtension = fileFilter instanceof SimpleFileFilter ? ((SimpleFileFilter)fileFilter).getExtension() : exportFormat.formatName();
    }

    public void setDestdir(File file) {
        this.destdir = file;
    }

    public void execute() throws BuildException {
        super.execute();
        Logger logger = Logger.getLogger((String)"CH.ifa.draw");
        AntTaskLogAppender antTaskLogAppender = AntTaskLogAppender.getInstance((Task)this);
        logger.addAppender((Appender)antTaskLogAppender);
        logger.setLevel(Level.INFO);
        logger = Logger.getLogger((String)"de.renew");
        logger.addAppender((Appender)antTaskLogAppender);
        logger.setLevel(Level.INFO);
        if (Iconkit.instance() == null) {
            new Iconkit((Component)new Frame());
        }
        for (FileSet fileSet : this.filesets) {
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.log("filenames: " + stringArray.length, 3);
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                File file = new File(directoryScanner.getBasedir() + "/" + string);
                this.log("File: " + file.getAbsolutePath(), 3);
                Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)new StatusDisplayer(){

                    public void showStatus(String string) {
                        AbstractExportTask.this.log(string);
                    }
                });
                this.log("Drawing: " + drawing, 3);
                try {
                    File file2 = new File(this.destdir + "/" + string);
                    File file3 = new File(file2.getParent() + "/" + drawing.getName() + "." + this.defaultExtension);
                    file3.getParentFile().mkdirs();
                    this.exportFormat.export(drawing, file3);
                    continue;
                }
                catch (Exception exception) {
                    throw new BuildException((Throwable)exception);
                }
            }
        }
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }
}

