/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.util.Iconkit;
import de.renew.io.exportFormats.EPSExportFormat;
import de.renew.plugin.command.CLCommand;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class ExportClCommand
implements CLCommand,
StatusDisplayer {
    private static Logger logger = Logger.getLogger(ExportClCommand.class);

    public void execute(String[] stringArray, PrintStream printStream) {
        if (Iconkit.instance() == null) {
            new Iconkit((Component)new Frame());
        }
        ExportHolderImpl exportHolderImpl = (ExportHolderImpl)DrawPlugin.getCurrent().getExportHolder();
        ExportFormat[] exportFormatArray = exportHolderImpl.allExportFormats();
        if (stringArray.length >= 2) {
            int n;
            String string = stringArray[0];
            EPSExportFormat ePSExportFormat = new EPSExportFormat();
            for (n = 0; n < exportFormatArray.length; ++n) {
                logger.debug((Object)exportFormatArray[n]);
                if (!exportFormatArray[n].formatName().toLowerCase().equals(string.toLowerCase())) continue;
                ePSExportFormat = exportFormatArray[n];
                logger.info((Object)(ExportClCommand.class.getName() + ": format is " + ePSExportFormat.formatName()));
                if (!(ePSExportFormat.fileFilter() instanceof SimpleFileFilter)) break;
                string = ((SimpleFileFilter)ePSExportFormat.fileFilter()).getExtension();
                break;
            }
            for (n = 1; n < stringArray.length; ++n) {
                String string2 = stringArray[n];
                logger.info((Object)(ExportClCommand.class.getName() + ": filename is " + string2));
                File file = new File(string2);
                if (!file.exists()) continue;
                Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)this);
                logger.info((Object)(ExportClCommand.class.getName() + ": drawing is " + drawing.getName()));
                File file2 = new File(drawing.getFilename().getAbsoluteFile().getParentFile(), drawing.getName() + "." + string);
                logger.info((Object)(ExportClCommand.class.getName() + ": path is " + file2));
                exportHolderImpl.saveDrawing(drawing, (ExportFormat)ePSExportFormat, file2, (StatusDisplayer)this);
            }
        }
    }

    public String getDescription() {
        return "Exports a drawing. Useage: ex <extension> <drawing> ";
    }

    public void showStatus(String string) {
        logger.info((Object)(ExportClCommand.class.getName() + " Status: " + string));
    }
}

