/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class IOHelper {
    public static Logger logger = Logger.getLogger(IOHelper.class);
    private static IOHelper _instance;
    private File lastPath = new File(System.getProperty("user.dir"));
    private SimpleFileFilter lastSelectedFileFilter = DrawingTypeManager.getInstance().getDefaultFileFilter();

    private IOHelper() {
    }

    static IOHelper getInstance() {
        if (_instance == null) {
            _instance = new IOHelper();
        }
        return _instance;
    }

    public File getLastPath() {
        return this.lastPath;
    }

    public File getSavePath(File file, SimpleFileFilter simpleFileFilter) {
        if (DrawPlugin.getGui() == null) {
            logger.debug((Object)"could not open save dialog: no gui!");
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (simpleFileFilter == null) {
            return null;
        }
        if (file == null) {
            file = DrawPlugin.getGui().drawing().getFilename();
        }
        if (file == null) {
            file = this.lastPath;
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(simpleFileFilter);
        jFileChooser.setCurrentDirectory(this.getCurrentDirectory(file));
        file = new File(StringUtil.stripFilenameExtension((String)file.getPath()) + "." + simpleFileFilter.getExtension());
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(DrawPlugin.getGui().getFrame());
        if (n == 0) {
            this.lastPath = jFileChooser.getCurrentDirectory();
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    public CombinationFileFilter getFileFilter() {
        CombinationFileFilter combinationFileFilter = new CombinationFileFilter("All known input file types");
        Enumeration<String> enumeration = this.getDrawingTypeManager().getDrawingTypes().keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            combinationFileFilter.add(this.getDrawingTypeManager().getFilter(string));
        }
        if (combinationFileFilter.isEmpty()) {
            return null;
        }
        combinationFileFilter.setPreferedFileFilter(this.lastSelectedFileFilter);
        return combinationFileFilter;
    }

    protected DrawingTypeManager getDrawingTypeManager() {
        return DrawingTypeManager.getInstance();
    }

    public File getSavePath(File file, SimpleFileFilter[] simpleFileFilterArray) {
        int n;
        if (DrawPlugin.getGui() == null) {
            logger.debug((Object)"could not open save dialog: no gui!");
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (simpleFileFilterArray == null) {
            return null;
        }
        if (file == null) {
            file = DrawPlugin.getGui().drawing().getFilename();
        }
        if (file == null) {
            file = this.lastPath;
        }
        jFileChooser.setAcceptAllFileFilterUsed(false);
        for (n = 0; n < simpleFileFilterArray.length; ++n) {
            jFileChooser.addChoosableFileFilter(simpleFileFilterArray[n]);
        }
        jFileChooser.setFileFilter(simpleFileFilterArray[0]);
        jFileChooser.setCurrentDirectory(this.getCurrentDirectory(file));
        file = new File(StringUtil.stripFilenameExtension((String)file.getPath()) + "." + simpleFileFilterArray[0].getExtension());
        jFileChooser.setSelectedFile(file);
        n = jFileChooser.showSaveDialog(DrawPlugin.getGui().getFrame());
        if (n == 0) {
            this.lastPath = jFileChooser.getCurrentDirectory();
            return DrawingFileHelper.checkAndAddExtension(jFileChooser.getSelectedFile(), (SimpleFileFilter)jFileChooser.getFileFilter());
        }
        return null;
    }

    public File getCurrentDirectory(File file) {
        File file2;
        if (file != null && (file2 = file.getParentFile()) != null && file2.exists()) {
            return file2;
        }
        return this.lastPath;
    }

    public File[] getLoadPath(File file, FileFilter fileFilter, boolean bl) {
        int n;
        Object object;
        File file2 = this.getCurrentDirectory(file);
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setMultiSelectionEnabled(bl);
        if (fileFilter != null) {
            if (fileFilter instanceof CombinationFileFilter) {
                CombinationFileFilter combinationFileFilter = (CombinationFileFilter)fileFilter;
                object = combinationFileFilter.getFileFilters().iterator();
                while (object.hasNext()) {
                    jFileChooser.addChoosableFileFilter(object.next());
                }
                jFileChooser.setFileFilter(combinationFileFilter.getPreferedFileFilter());
            } else {
                jFileChooser.addChoosableFileFilter(fileFilter);
            }
        } else {
            jFileChooser.setAcceptAllFileFilterUsed(true);
        }
        if (file != null) {
            jFileChooser.setCurrentDirectory(file);
        }
        if ((n = jFileChooser.showOpenDialog(DrawPlugin.getGui().getFrame())) == 0) {
            this.lastPath = jFileChooser.getCurrentDirectory();
            object = (SimpleFileFilter)jFileChooser.getFileFilter();
            if (jFileChooser.getFileFilter() instanceof SimpleFileFilter && DrawingTypeManager.getInstance().getDrawingTypes().values().contains(object)) {
                this.lastSelectedFileFilter = object;
            }
            if (bl) {
                return jFileChooser.getSelectedFiles();
            }
            File[] fileArray = new File[]{jFileChooser.getSelectedFile()};
            return fileArray;
        }
        return null;
    }

    public File getLoadPath(File file, FileFilter fileFilter) {
        File[] fileArray = this.getLoadPath(file, fileFilter, false);
        if (fileArray == null) {
            return null;
        }
        return fileArray[0];
    }

    public File[] getLoadPath(FileFilter fileFilter) {
        File[] fileArray = null;
        fileArray = this.getLoadPath(null, fileFilter, true);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        assert (fileArray != null) : "Failure in GuiPlugin: result == null";
        return fileArray;
    }

    public File[] getLoadPath(FileFilter[] fileFilterArray) {
        File[] fileArray = null;
        CombinationFileFilter combinationFileFilter = new CombinationFileFilter("All");
        for (int i = 0; i < fileFilterArray.length; ++i) {
            combinationFileFilter.add((SimpleFileFilter)fileFilterArray[i]);
        }
        fileArray = this.getLoadPath(combinationFileFilter);
        assert (fileArray != null) : "Failure in GuiPlugin: result == null";
        return fileArray;
    }

    public synchronized void loadAndOpenDrawing(URL uRL) {
        PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(uRL, null);
        if (positionedDrawing != null) {
            DrawPlugin.getGui().openDrawing(positionedDrawing);
        }
    }

    public synchronized void loadAndOpenDrawing(InputStream inputStream, String string) throws FileNotFoundException, IOException {
        PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(inputStream, string);
        if (positionedDrawing != null) {
            try {
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (drawApplication != null) {
                    drawApplication.openDrawing(positionedDrawing);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public synchronized void loadInViewContainer(PositionedDrawing positionedDrawing) {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication != null) {
            drawApplication.openDrawing(positionedDrawing);
        }
    }

    public synchronized void loadAndOpenDrawing(File file) {
        PositionedDrawing positionedDrawing = DrawingFileHelper.loadPositionedDrawing(file, null);
        DrawPlugin.getGui().openDrawing(positionedDrawing);
        if (positionedDrawing != null) {
            positionedDrawing.getDrawing().init();
        }
    }

    public File getSaveFile(File file, SimpleFileFilter[] simpleFileFilterArray, Drawing drawing) {
        File file2;
        File file3 = null;
        if (file == null && (file = drawing.getFilename()) == null) {
            file = new File(this.getLastPath(), drawing.getName());
            file = DrawingFileHelper.checkAndAddExtension(file, simpleFileFilterArray[0]);
        }
        if ((file2 = this.getSavePath(file, simpleFileFilterArray)) != null) {
            if (file2.exists()) {
                DrawApplication drawApplication = DrawPlugin.getGui();
                int n = JOptionPane.showConfirmDialog(drawApplication.getViewContainer(drawing).getFrame(), "The file \"" + file2 + "\"" + " does already exist." + "\nDo you want do proceed?", "Renew: Confirm overwrite.", 0);
                if (n == 0) {
                    file3 = file2;
                }
            } else {
                file3 = file2;
            }
        }
        return file3;
    }

    public void setLastPath(File file) {
        this.lastPath = file;
    }
}

