/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.util.GUIProperties;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class DrawingLoadClient {
    public static Logger logger = Logger.getLogger(DrawingLoadClient.class);

    public static void loadDrawings(String[] stringArray) {
        int n = GUIProperties.loadServerPort();
        if (n == -1) {
            logger.error((Object)"No port specified, please set property de.renew.loadServerPort.");
            System.exit(1);
        }
        try {
            Socket socket = new Socket("127.0.0.1", n);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
            logger.info((Object)("Passing file names to " + socket.getInetAddress() + ":" + socket.getPort() + "..."));
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.println(StringUtil.makeCanonical((String)stringArray[i]));
            }
            printWriter.close();
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
            logger.error((Object)"localhost (127.0.0.1) not found. Please set up TCP/IP correctly.");
            System.exit(2);
        }
        catch (IOException iOException) {
            logger.error((Object)("Probably the DrawingLoadServer is not running on port " + n + "? Exception:\n" + iOException));
            System.exit(2);
        }
    }

    public static void main(String[] stringArray) {
        PluginManager.configureLogging();
        GUIProperties.setProperties((Properties)PluginProperties.getUserProperties());
        DrawingLoadClient.loadDrawings(stringArray);
    }
}

