/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawingViewContainer;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.standard.NullDrawingView;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.util.GUIProperties;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DrawingViewFrame
extends JFrame
implements DrawingViewContainer {
    private StandardDrawingView drawingView;
    private JScrollPane sp;
    private InputEventForwarder forwarder;
    private boolean onDiscardReleaseDrawing = false;
    protected DrawingEditor editor;
    private static final int VERTICAL_SCROLL_INCREMENT = 75;
    private static final int HORIZONTAL_SCROLL_INCREMENT = 75;

    public DrawingViewFrame(DrawingEditor drawingEditor, StandardDrawingView standardDrawingView, Drawing drawing) {
        this(drawingEditor, standardDrawingView, drawing, null, null);
    }

    public DrawingViewFrame(DrawingEditor drawingEditor, StandardDrawingView standardDrawingView, Drawing drawing, Point point, Dimension dimension) {
        Object object;
        this.setDefaultCloseOperation(0);
        this.editor = drawingEditor;
        Image image = drawingEditor.getIconImage();
        if (image != null && (object = Toolkit.getDefaultToolkit().createImage(image.getSource())) != null) {
            this.setIconImage((Image)object);
        }
        this.drawingView = standardDrawingView;
        standardDrawingView.setDrawing(drawing);
        this.forwarder = new InputEventForwarder(this);
        standardDrawingView.addMouseListener(this.forwarder);
        standardDrawingView.addMouseMotionListener(this.forwarder);
        standardDrawingView.addKeyListener(this.forwarder);
        this.addWindowListener(new ContainerEventForwarder());
        this.sp = new JScrollPane(standardDrawingView, 22, 32);
        this.sp.getViewport().setScrollMode(1);
        this.sp.setAutoscrolls(true);
        this.sp.getVerticalScrollBar().setUnitIncrement(75);
        this.sp.getHorizontalScrollBar().setUnitIncrement(75);
        this.getContentPane().add(this.sp);
        object = this.defaultLocationAndSize(standardDrawingView);
        if (dimension == null) {
            dimension = new Dimension(((Rectangle)object).width, ((Rectangle)object).height);
        }
        if (point == null) {
            point = new Point(((Rectangle)object).x, ((Rectangle)object).y);
        }
        if (GUIProperties.avoidFrameReshape()) {
            this.sp.setSize(dimension.width, dimension.height);
            this.pack();
        } else {
            this.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.validate();
        }
        if (drawingEditor.tool() == null) {
            drawingEditor.toolDone();
        }
        this.setTitle(drawing.getName());
        this.setVisible(true);
        this.validate();
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public DrawingView view() {
        DrawingView drawingView = this.drawingView;
        if (drawingView == null) {
            drawingView = NullDrawingView.INSTANCE;
        }
        return drawingView;
    }

    protected Rectangle defaultLocationAndSize(DrawingView drawingView) {
        Dimension dimension = this.editor.getSize();
        Point point = this.editor.getLocationOnScreen();
        Rectangle rectangle = new Rectangle(point.x, point.y + dimension.height, dimension.width, 600);
        if (drawingView.drawing().figures().hasMoreElements()) {
            if (!this.isShowing()) {
                this.pack();
            }
            Insets insets = this.sp.getInsets();
            Insets insets2 = this.getInsets();
            Dimension dimension2 = new Dimension(insets.left + insets.right + insets2.left + insets2.right, insets.top + insets.bottom + insets2.top + insets2.bottom);
            Dimension dimension3 = drawingView.getPreferredSize();
            int n = dimension3.width + dimension2.width + 16;
            int n2 = dimension3.height + dimension2.height + 16;
            Dimension dimension4 = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle.setSize(Math.min(n, dimension4.width), Math.min(n2, dimension4.height));
        }
        return rectangle;
    }

    @Override
    public void onDiscardRelease() {
        this.onDiscardReleaseDrawing = true;
    }

    @Override
    public void discard() {
        this.setVisible(false);
        this.forwarder.discard();
        this.sp.remove(this.drawingView);
        this.remove(this.sp);
        if (this.onDiscardReleaseDrawing) {
            this.drawingView.drawing().release();
        }
        this.drawingView.setDrawing(NullDrawing.INSTANCE);
        this.drawingView = null;
        this.sp = null;
        this.dispose();
    }

    @Override
    public void setTitle(Drawing drawing) {
        String string = drawing.getWindowCategory();
        super.setTitle(string.substring(0, string.length() - 1) + "  " + drawing.getName());
    }

    protected class ContainerEventForwarder
    extends WindowAdapter {
        protected ContainerEventForwarder() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            DrawingViewFrame.this.editor.drawingViewContainerActivated(DrawingViewFrame.this);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DrawingViewFrame.this.editor.drawingViewContainerClosing(DrawingViewFrame.this);
        }
    }

    private class InputEventForwarder
    implements KeyListener,
    MouseMotionListener,
    MouseListener {
        private DrawingViewFrame frame;
        private boolean active;

        public InputEventForwarder(DrawingViewFrame drawingViewFrame2) {
            this.frame = drawingViewFrame2;
            this.active = true;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.mouseClicked(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.active) {
                DrawingViewFrame.this.editor.setCurrentDrawing(this.frame);
            }
            if (this.active) {
                DrawingViewFrame.this.drawingView.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.mouseEntered(mouseEvent);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.mouseExited(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.active) {
                Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
                ((JPanel)mouseEvent.getSource()).scrollRectToVisible(rectangle);
                DrawingViewFrame.this.drawingView.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.mouseMoved(mouseEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.keyTyped(keyEvent);
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (this.active) {
                DrawingViewFrame.this.editor.setCurrentDrawing(this.frame);
            }
            if (this.active) {
                DrawingViewFrame.this.drawingView.keyPressed(keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (this.active) {
                DrawingViewFrame.this.drawingView.keyReleased(keyEvent);
            }
        }

        public void discard() {
            this.active = false;
            this.frame = null;
        }
    }
}

