/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.FigureAttributes;
import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Decoration;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.IOException;
import java.util.Enumeration;

public abstract class AttributeFigure
extends AbstractFigure
implements FigureWithID {
    private static FigureAttributes fgDefaultAttributes = null;
    private static final long serialVersionUID = -10857585979273442L;
    private static final String _idAttr = "FigureWithID";
    public static final String LINE_STYLE_NORMAL = "";
    public static final String LINE_STYLE_DOTTED = "1 2";
    public static final String LINE_STYLE_DASHED = "10";
    public static final String LINE_STYLE_MEDIUM_DASHED = "15 10";
    public static final String LINE_STYLE_LONG_DASHED = "20";
    public static final String LINE_STYLE_DASH_DOTTED = "7 3 1 3";
    public static final String LINE_WIDTH_KEY = "LineWidth";
    private FigureAttributes fAttributes;
    private int attributeFigureSerializedDataVersion = 1;

    protected AttributeFigure() {
    }

    public void internalDraw(Graphics graphics) {
        Color color;
        Color color2 = this.getFillColor();
        if (!ColorMap.isTransparent(color2)) {
            graphics.setColor(color2);
            this.drawBackground(graphics);
        }
        if (!ColorMap.isTransparent(color = this.getFrameColor())) {
            graphics.setColor(color);
            Graphics2D graphics2D = (Graphics2D)graphics;
            String string = this.getLineStyle();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.getBasicStroke(string));
            this.drawFrame(graphics2D);
            graphics2D.setStroke(stroke);
        }
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            this.internalDraw(graphics);
            this.drawDecorations(graphics);
        }
    }

    @Override
    public void draw(Graphics graphics, DrawingContext drawingContext) {
        if (!drawingContext.isVisible(this)) {
            return;
        }
        if (drawingContext.isHighlighted(this)) {
            Color color = this.getFillColor();
            Color color2 = this.getFrameColor();
            Color color3 = null;
            if (ColorMap.isTransparent(color) || ColorMap.isBackground(color) || this instanceof PolyLineFigure) {
                if (this instanceof TextFigure) {
                    color3 = (Color)this.getAttribute("TextColor");
                    this.setTextColor(ColorMap.hilight(color3));
                } else if (!ColorMap.isTransparent(color2) && !ColorMap.isBackground(color)) {
                    this.setFrameColor(ColorMap.hilight(color2));
                }
            } else {
                this.setFillColor(ColorMap.hilight(color));
            }
            this.internalDraw(graphics);
            this.setFillColor(color);
            this.setFrameColor(color2);
            if (color3 != null) {
                this.setTextColor(color3);
            }
        } else {
            this.internalDraw(graphics);
        }
    }

    protected void drawBackground(Graphics graphics) {
    }

    protected void drawFrame(Graphics graphics) {
    }

    public Color getFillColor() {
        return (Color)this.getAttribute("FillColor");
    }

    public Color getFrameColor() {
        return (Color)this.getAttribute("FrameColor");
    }

    public void setFillColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("FillColor", color);
    }

    public void setFrameColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("FrameColor", color);
    }

    public void setTextColor(Color color) {
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set("TextColor", color);
    }

    private static void initializeAttributes() {
        fgDefaultAttributes = new FigureAttributes();
        fgDefaultAttributes.set("FrameColor", Color.black);
        fgDefaultAttributes.set("FillColor", new Color(7396243));
        fgDefaultAttributes.set("TextColor", Color.black);
        fgDefaultAttributes.set("TextAlignment", new Integer(0));
        fgDefaultAttributes.set("ArrowMode", new Integer(0));
        fgDefaultAttributes.set("FontName", "Helvetica");
        fgDefaultAttributes.set("FontSize", new Integer(12));
        fgDefaultAttributes.set("FontStyle", new Integer(0));
        fgDefaultAttributes.set("LineShape", new Integer(0));
        fgDefaultAttributes.set("BSplineSegments", new Integer(15));
        fgDefaultAttributes.set("BSplineDegree", new Integer(2));
        fgDefaultAttributes.set(_idAttr, new Integer(0));
    }

    public static Object getDefaultAttribute(String string) {
        if (fgDefaultAttributes == null) {
            AttributeFigure.initializeAttributes();
        }
        return fgDefaultAttributes.get(string);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(string)) {
            return this.fAttributes.get(string);
        }
        Object object = super.getAttribute(string);
        if (object == null) {
            return AttributeFigure.getDefaultAttribute(string);
        }
        return object;
    }

    public Boolean hasAttribute(String string) {
        if (this.fAttributes != null && this.fAttributes.hasDefined(string)) {
            return true;
        }
        if (super.getAttribute(string) != null) {
            return true;
        }
        return false;
    }

    public Enumeration<String> getAttributeKeys() {
        Enumeration<String> enumeration = new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                return null;
            }
        };
        if (this.fAttributes != null) {
            enumeration = this.fAttributes.definedAttributes();
        }
        return enumeration;
    }

    @Override
    public void setAttribute(String string, Object object) {
        super.setAttribute(string, object);
        if (this.fAttributes == null) {
            this.fAttributes = new FigureAttributes();
        }
        this.fAttributes.set(string, object);
        this.changed();
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        if (this.fAttributes == null) {
            storableOutput.writeString("no_attributes");
        } else {
            storableOutput.writeString("attributes");
            this.fAttributes.write(storableOutput);
        }
        if (this.isDecorated()) {
            storableOutput.writeString("decorations");
            storableOutput.writeInt(this.getDecorations().size());
            for (Decoration decoration : this.getDecorations()) {
                logger.info((Object)("[AttributeFigure] Storing decoration " + decoration));
                storableOutput.writeStorable(decoration);
            }
        }
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        Object object;
        super.read(storableInput);
        String string = storableInput.readString();
        if (string.toLowerCase().equals("attributes")) {
            if (this.fAttributes == null) {
                this.fAttributes = new FigureAttributes();
            }
            this.fAttributes.read(storableInput);
            object = this.fAttributes.definedAttributes();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                Object object2 = this.fAttributes.get(string2);
                super.setAttribute(string2, object2);
            }
        }
        logger.debug((Object)"READ> start reading decorations");
        try {
            object = storableInput.readString();
            if (((String)object).toLowerCase().equals("decorations")) {
                int n = storableInput.readInt();
                logger.debug((Object)("READ> expecting " + n + "decoration" + (n >= 1 ? "s." : ".")));
                for (int i = 0; i < n; ++i) {
                    Storable storable = storableInput.readStorable();
                    logger.debug((Object)("READ> found storable " + storable));
                    if (!(storable != null & storable instanceof Decoration)) continue;
                    this.addDecoration((Decoration)storable);
                }
            } else {
                logger.debug((Object)"READ> Not decoration, putting back token");
                storableInput.putBack();
            }
        }
        catch (IOException iOException) {
            logger.debug((Object)("READ> Not decoration, putting back token " + iOException));
            storableInput.putBack();
        }
    }

    @Override
    public int getID() {
        return (Integer)this.getAttribute(_idAttr);
    }

    @Override
    public void setID(int n) {
        this.setAttribute(_idAttr, new Integer(n));
    }

    protected String getLineStyle() {
        String string = (String)this.getAttribute("LineStyle");
        if (string == null) {
            return LINE_STYLE_NORMAL;
        }
        return string;
    }

    protected void setLineStyle(String string) {
        this.setAttribute("LineStyle", string);
    }

    protected BasicStroke getBasicStroke(String string) {
        float[] fArray;
        if (string != LINE_STYLE_NORMAL && string.length() != 0) {
            String[] stringArray = string.split(" ");
            fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
        } else {
            fArray = null;
        }
        return new BasicStroke(1.0f, 0, 2, 0.0f, fArray, 0.0f);
    }
}

