/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.framework.Decoration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class DecorationImpl
implements Decoration {
    public static Logger logger = Logger.getLogger(DecorationImpl.class);
    private int xOffset;
    private int yOffset;
    private int orientation;
    private ImageIcon icon;
    protected int iconWidth;
    protected int iconHeight;
    public static final int TopLeftOrientation = 0;
    public static final int BottomLeftOrientation = 1;
    public static final int TopRightOrientation = 2;
    public static final int BottomRightOrientation = 3;
    private static final String defaultIconFilename = "/CH/ifa/draw/images/LINKICON.gif";
    private static final ImageIcon defaultIcon = DecorationImpl.initDefaultIcon("/CH/ifa/draw/images/LINKICON.gif");

    public DecorationImpl() {
        this(0, 0, 0);
    }

    public DecorationImpl(int n, int n2, int n3) {
        this.xOffset = n;
        this.yOffset = n2;
        this.orientation = n3;
        this.setIcon(defaultIcon);
    }

    public DecorationImpl(int n, int n2, int n3, ImageIcon imageIcon) {
        this(n, n2, n3);
        this.setIcon(imageIcon);
    }

    public DecorationImpl(ImageIcon imageIcon) {
        this.setIcon(imageIcon);
    }

    protected static ImageIcon initDefaultIcon(String string) {
        ImageIcon imageIcon = null;
        logger.info((Object)("[DecorationImpl.initDefaultIcon] filename is " + string));
        URL uRL = DecorationImpl.class.getResource(string);
        if (uRL == null) {
            logger.error((Object)"[Decoration] Could not find default icon");
        } else {
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon;
    }

    private void setIcon(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.icon = imageIcon;
            this.iconWidth = imageIcon.getIconWidth();
            this.iconHeight = imageIcon.getIconHeight();
        } else {
            logger.error((Object)"[DecorationImpl.setIcon] Can't set null icon");
        }
    }

    @Override
    public void draw(Graphics graphics, Rectangle rectangle) {
        if (this.icon != null) {
            Point point = this.getCoordinates(rectangle);
            logger.debug((Object)("[DecorationImpl.draw()] Drawing Decoration at (" + point.x + "," + point.y + ")"));
            this.icon.paintIcon(null, graphics, point.x, point.y);
        }
    }

    protected Point getCoordinates(Rectangle rectangle) {
        int n = this.orientation < 2 ? rectangle.x + this.xOffset : rectangle.x + rectangle.width - this.xOffset - this.iconWidth;
        int n2 = this.orientation % 2 == 0 ? rectangle.y + this.yOffset : rectangle.y + rectangle.height - this.yOffset - this.iconHeight;
        return new Point(n, n2);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        storableOutput.writeInt(this.xOffset);
        storableOutput.writeInt(this.yOffset);
        storableOutput.writeInt(this.orientation);
        if (this.icon != null) {
            storableOutput.writeString(this.icon.getDescription());
        }
        logger.info((Object)("URI of storable stream: " + storableOutput.getURI()));
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        this.xOffset = storableInput.readInt();
        this.yOffset = storableInput.readInt();
        this.orientation = storableInput.readInt();
        String string = storableInput.readString();
        logger.debug((Object)("READ> icon filepath: " + string));
        this.setIcon(DecorationImpl.initDefaultIcon(string));
    }
}

