/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ImageFigureCreationTool
extends CreationTool
implements ImageObserver {
    public static Logger logger = Logger.getLogger(ImageFigureCreationTool.class);
    private Image image;
    private String fImageName = null;
    private JFrame frame;

    public ImageFigureCreationTool(DrawingEditor drawingEditor, JFrame jFrame) {
        super(drawingEditor);
        this.frame = jFrame;
    }

    @Override
    public void activate() {
        super.activate();
        this.image = null;
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Open Image...", 0);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        this.fImageName = string != null ? fileDialog.getDirectory() + string : null;
        fileDialog.dispose();
        if (this.fImageName != null) {
            this.image = Toolkit.getDefaultToolkit().getImage(this.fImageName);
            if (this.image != null) {
                MediaTracker mediaTracker = new MediaTracker(this.frame);
                mediaTracker.addImage(this.image, 123);
                try {
                    mediaTracker.waitForAll();
                }
                catch (Exception exception) {
                    this.image = null;
                }
            }
            if (this.image == null) {
                this.noChangesMade();
                this.fEditor.toolDone();
                this.fEditor.showStatus("Image " + this.fImageName + " could not be loaded!");
            }
        } else {
            this.noChangesMade();
            this.fEditor.toolDone();
            this.fEditor.showStatus("Image creation canceled.");
        }
    }

    @Override
    protected Figure createFigure() {
        if (this.fImageName != null && this.image != null) {
            Point point = this.fEditor.view().lastClick();
            return new ImageFigure(this.image, this.fImageName, point);
        }
        return null;
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        Figure figure = this.createdFigure();
        if (figure != null && figure.isEmpty()) {
            Point point = figure.displayBox().getLocation();
            int n3 = this.image.getWidth(this);
            int n4 = this.image.getHeight(this);
            if (n3 == -1 || n4 == -1) {
                logger.error((Object)"Image not loaded properly!");
            } else {
                figure.displayBox(point, new Point(point.x + n3, point.y + n4));
            }
        }
        super.mouseUp(mouseEvent, n, n2);
    }

    @Override
    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }
}

