/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.ClickableDecoration;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;

public class LinkDecoration
extends ClickableDecoration {
    private static final long serialVersionUID = 125012030821382479L;
    private File link;
    private static final String defaultIconFilename = "/CH/ifa/draw/images/LINKICON.gif";
    private static final ImageIcon defaultLinkIcon = LinkDecoration.initDefaultIcon("/CH/ifa/draw/images/LINKICON.gif");

    public LinkDecoration() {
    }

    public LinkDecoration(File file) {
        super(defaultLinkIcon);
        this.link = file;
    }

    public LinkDecoration(int n, int n2, int n3, File file) {
        super(n, n2, n3, defaultLinkIcon);
        this.link = file;
    }

    @Override
    public void clicked() {
        logger.info((Object)("[LinkDecoration] Trying to load link to " + this.link));
        DrawApplication drawApplication = DrawPlugin.getGui();
        Drawing drawing = DrawingFileHelper.loadDrawing(this.link, (StatusDisplayer)drawApplication);
        if (drawing != null && drawApplication != null) {
            drawApplication.openDrawing(drawing);
        } else {
            logger.error((Object)"[LinkDecoration] Either no gui or no drawing: ");
        }
    }

    private void setLink(String string) {
        this.link = new File(string);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        if (this.link != null) {
            storableOutput.writeString(this.link.toString());
        }
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        String string = storableInput.readString();
        logger.debug((Object)("[LinkDecoration] Read linkString " + string));
        this.link = new File(string);
    }
}

