/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.MergedFigureEnumerator;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.OffsetLocator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.standard.TextHolder;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.ExtendedFont;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TextFigure
extends AttributeFigure
implements ChildFigure,
TextHolder {
    public static Logger logger = Logger.getLogger(TextFigure.class);
    private static String fgCurrentFontName = "SansSerif";
    private static int fgCurrentFontSize = 12;
    private static int fgCurrentFontStyle = 0;
    private static final long serialVersionUID = 4599820785949456124L;
    public static final String ALIGN_ATTR = "TextAlignment";
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int fOriginX = 0;
    private int fOriginY = 0;
    private transient boolean fSizeIsDirty = true;
    private transient int fWidth;
    private transient int fHeight;
    private transient Rectangle[] boxes;
    private String fText;
    private String[] fLines;
    private transient Font fFont = null;
    private String fCurrentFontName = fgCurrentFontName;
    private int fCurrentFontSize;
    private int fCurrentFontStyle = fgCurrentFontStyle;
    private boolean fIsReadOnly;
    private boolean fCanBeConnected = true;
    private ParentFigure fParent = null;
    private OffsetLocator fLocator = null;
    private int textFigureSerializedDataVersion = 1;

    public TextFigure() {
        this("");
    }

    public TextFigure(boolean bl) {
        this("");
        this.fCanBeConnected = bl;
    }

    public TextFigure(String string) {
        this.fCurrentFontSize = fgCurrentFontSize;
        this.setAttribute("FillColor", ColorMap.color("None"));
        this.setAttribute("FrameColor", ColorMap.color("None"));
        this.internalSetText(string);
        this.fSizeIsDirty = true;
    }

    public TextFigure(String string, boolean bl) {
        this(string);
        this.setReadOnly(bl);
    }

    @Override
    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        if (this.fLocator != null) {
            this.fLocator.moveBy(n, n2);
        }
        this.changed();
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        this.fOriginX += n;
        this.fOriginY += n2;
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
        this.fOriginX = point.x;
        this.fOriginY = point.y;
    }

    public Point getOrigin() {
        return new Point(this.fOriginX, this.fOriginY);
    }

    @Override
    public Rectangle displayBox() {
        this.textExtent();
        return new Rectangle(this.fOriginX, this.fOriginY, this.fWidth, this.fHeight);
    }

    @Override
    public Rectangle textDisplayBox() {
        return this.displayBox();
    }

    protected String getLine(int n) {
        return this.fLines[n];
    }

    protected int getLineAlignment(int n) {
        return this.getAlignment();
    }

    protected Font getLineFont(int n) {
        return this.getFont();
    }

    public static FontMetrics getMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getLineBox(int n) {
        if (this.fSizeIsDirty) {
            this.getLineBoxes();
        }
        return this.boxes[n];
    }

    protected Dimension getLineDimension(int n) {
        FontMetrics fontMetrics = TextFigure.getMetrics(this.getLineFont(n));
        return new Dimension(fontMetrics.stringWidth(this.getLine(n)), fontMetrics.getHeight());
    }

    protected Rectangle[] getLineBoxes() {
        if (this.fSizeIsDirty) {
            int n;
            this.boxes = new Rectangle[this.fLines.length];
            int n2 = this.fWidth;
            this.fWidth = 0;
            this.fHeight = 0;
            for (n = 0; n < this.fLines.length; ++n) {
                Dimension dimension = this.getLineDimension(n);
                this.boxes[n] = new Rectangle(0, this.fHeight, dimension.width, dimension.height);
                this.fWidth = Math.max(this.fWidth, dimension.width);
                this.fHeight += dimension.height;
            }
            for (n = 0; n < this.fLines.length; ++n) {
                int n3 = this.getLineAlignment(n);
                if (n3 == 0) continue;
                int n4 = this.fWidth - this.boxes[n].width;
                if (n3 == 1) {
                    n4 /= 2;
                }
                this.boxes[n].translate(n4, 0);
            }
            if (n2 != 0) {
                switch (this.getAlignment()) {
                    case 2: {
                        this.fOriginX = this.fOriginX + n2 - this.fWidth;
                        if (this.fLocator == null) break;
                        this.fLocator.moveBy((n2 - this.fWidth) / 2, 0);
                        break;
                    }
                    case 1: {
                        this.fOriginX += (n2 - this.fWidth) / 2;
                        break;
                    }
                    default: {
                        if (this.fLocator == null) break;
                        this.fLocator.moveBy(-(n2 - this.fWidth) / 2, 0);
                    }
                }
            }
            this.fSizeIsDirty = false;
        }
        return this.boxes;
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        if (super.containsPoint(n, n2)) {
            if (!ColorMap.isTransparent(this.getFrameColor())) {
                return true;
            }
            n -= this.fOriginX;
            n2 -= this.fOriginY;
            Rectangle[] rectangleArray = this.getLineBoxes();
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (!rectangleArray[i].contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean readOnly() {
        return this.fIsReadOnly;
    }

    @Override
    public void setReadOnly(boolean bl) {
        this.fIsReadOnly = bl;
    }

    @Override
    public Font getFont() {
        if (this.fFont == null) {
            this.fFont = Fontkit.getFont(this.fCurrentFontName, this.fCurrentFontStyle, this.fCurrentFontSize);
        }
        return this.fFont;
    }

    public void setFont(Font font) {
        this.willChange();
        this.fFont = font;
        this.fCurrentFontName = this.fFont.getName();
        this.fCurrentFontStyle = this.fFont.getStyle();
        this.fCurrentFontSize = this.fFont.getSize();
        this.markDirty();
        this.changed();
    }

    @Override
    public void changed() {
        super.changed();
        this.updateLocation();
    }

    public int getAlignment() {
        return (Integer)this.getAttribute(ALIGN_ATTR);
    }

    public void setAlignment(int n) {
        this.setAttribute(ALIGN_ATTR, new Integer(n));
    }

    @Override
    public Object getAttribute(String string) {
        if (string.equals("FontSize")) {
            return new Integer(this.fCurrentFontSize);
        }
        if (string.equals("FontStyle")) {
            return new Integer(this.fCurrentFontStyle);
        }
        if (string.equals("FontName")) {
            return this.fCurrentFontName;
        }
        return super.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (string.equals("FontSize") || string.equals("FontStyle") || string.equals("FontName")) {
            this.willChange();
            if (string.equals("FontSize")) {
                this.fCurrentFontSize = (Integer)object;
            } else if (string.equals("FontStyle")) {
                int n = (Integer)object;
                this.fCurrentFontStyle = n == 0 ? 0 : (this.fCurrentFontStyle ^= n);
            } else if (string.equals("FontName")) {
                this.fCurrentFontName = (String)object;
            }
            this.fFont = null;
            this.markDirty();
            this.changed();
            this.markDirty();
            this.changed();
        } else {
            super.setAttribute(string, object);
            if (string.equals(ALIGN_ATTR)) {
                this.willChange();
                this.markDirty();
                this.changed();
            }
        }
    }

    @Override
    public String getText() {
        return this.fText;
    }

    public String[] getLines() {
        return this.fLines;
    }

    @Override
    public void setText(String string) {
        if (!string.equals(this.fText)) {
            this.willChange();
            this.basicSetText(string);
            this.changed();
        }
    }

    protected void basicSetText(String string) {
        this.internalSetText(string);
        this.markDirty();
    }

    protected void internalSetText(String string) {
        this.fText = string;
        this.fLines = TextFigure.splitTextLines(string);
    }

    protected void internalSetTextHiddenParts(String string, String string2) {
        this.fText = string;
        this.fLines = TextFigure.splitTextLines(string2);
    }

    private static String[] splitTextLines(String string) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        boolean bl = true;
        while (stringTokenizer.hasMoreElements()) {
            object = stringTokenizer.nextToken();
            if ("\n".equals(object)) {
                object = "";
                bl = true;
            } else if (stringTokenizer.hasMoreElements()) {
                stringTokenizer.nextToken();
                bl = true;
            } else {
                bl = false;
            }
            vector.addElement(object);
        }
        if (bl) {
            vector.addElement("");
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    @Override
    public boolean acceptsTyping() {
        return !this.fIsReadOnly;
    }

    @Override
    public void internalDraw(Graphics graphics) {
        Color color;
        super.internalDraw(graphics);
        Color color2 = this.getFillColor();
        this.getLineBoxes();
        graphics.translate(this.fOriginX, this.fOriginY);
        if (ColorMap.isTransparent(this.getFrameColor()) && !ColorMap.isTransparent(color2)) {
            graphics.setColor(color2);
            for (int i = 0; i < this.fLines.length; ++i) {
                graphics.fillRect(this.boxes[i].x, this.boxes[i].y, this.boxes[i].width, this.boxes[i].height);
            }
        }
        if (!ColorMap.isTransparent(color = (Color)this.getAttribute("TextColor"))) {
            graphics.setColor(color);
            for (int i = 0; i < this.fLines.length; ++i) {
                this.drawLine(graphics, i);
            }
        }
        graphics.translate(-this.fOriginX, -this.fOriginY);
    }

    protected void drawLine(Graphics graphics, int n) {
        Font font = this.getLineFont(n);
        graphics.setFont(font);
        int n2 = this.boxes[n].x;
        int n3 = this.boxes[n].y;
        String string = this.getLine(n);
        graphics.drawString(string, n2, n3 + TextFigure.getMetrics(font).getAscent());
        if (font instanceof ExtendedFont && ((ExtendedFont)font).isUnderlined()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            LineMetrics lineMetrics = fontMetrics.getLineMetrics(string, graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n3 + (int)lineMetrics.getUnderlineOffset() + TextFigure.getMetrics(font).getAscent(), fontMetrics.stringWidth(string), (int)lineMetrics.getUnderlineThickness());
            graphics2D.fill(float_);
        }
    }

    @Override
    public void drawBackground(Graphics graphics) {
        if (!ColorMap.isTransparent(this.getFrameColor())) {
            Rectangle rectangle = this.displayBox();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.fill(float_);
        }
    }

    @Override
    public void drawFrame(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.draw(float_);
    }

    private Dimension textExtent() {
        this.getLineBoxes();
        return new Dimension(this.fWidth, this.fHeight);
    }

    protected void markDirty() {
        this.fSizeIsDirty = true;
    }

    @Override
    public Dimension overlayRowsAndColumns() {
        int n;
        int n2 = 20;
        String[] stringArray = this.getLines();
        for (n = 0; n < stringArray.length; ++n) {
            n2 = Math.max(n2, stringArray[n].length() + 3);
        }
        n = Math.max(1, stringArray.length);
        return new Dimension(n2, n);
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        vector.addElement(new FontSizeHandle(this, RelativeLocator.southWest()));
        return vector;
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fOriginX);
        storableOutput.writeInt(this.fOriginY);
        storableOutput.writeString(this.fText);
        storableOutput.writeString(this.fCurrentFontName);
        storableOutput.writeInt(this.fCurrentFontStyle);
        storableOutput.writeInt(this.fCurrentFontSize);
        storableOutput.writeBoolean(this.fIsReadOnly);
        storableOutput.writeStorable(this.fParent);
        storableOutput.writeStorable(this.fLocator);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fOriginX = storableInput.readInt();
        this.fOriginY = storableInput.readInt();
        String string = storableInput.readString();
        this.setText(string);
        this.fCurrentFontName = storableInput.readString();
        this.fCurrentFontStyle = storableInput.readInt();
        this.fCurrentFontSize = storableInput.readInt();
        if (storableInput.getVersion() < 8 && "Helvetica".equals(this.fCurrentFontName)) {
            this.fCurrentFontName = "SansSerif";
        }
        this.fFont = null;
        this.fIsReadOnly = storableInput.readBoolean();
        this.fParent = (ParentFigure)storableInput.readStorable();
        this.fLocator = (OffsetLocator)storableInput.readStorable();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        } else {
            this.fCanBeConnected = false;
        }
        if (GUIProperties.noGraphics()) {
            this.fSizeIsDirty = false;
        } else {
            this.updateLocation();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.fParent != null) {
            this.fParent.addChild(this);
        }
        this.markDirty();
    }

    @Override
    public boolean canBeParent(ParentFigure parentFigure) {
        if (!this.fCanBeConnected) {
            return parentFigure == null;
        }
        while (parentFigure != null) {
            if (parentFigure == this) {
                return false;
            }
            if (!(parentFigure instanceof ChildFigure)) break;
            parentFigure = ((ChildFigure)((Object)parentFigure)).parent();
        }
        return true;
    }

    @Override
    public boolean setParent(ParentFigure parentFigure) {
        if (!this.canBeParent(parentFigure)) {
            return false;
        }
        if (this.fParent != null) {
            this.fParent.removeChild(this);
        }
        this.fParent = parentFigure;
        if (this.fParent == null) {
            this.fLocator = null;
        } else {
            this.fParent.addChild(this);
            if (this.fLocator != null) {
                this.fLocator.setBase(this.fParent.connectedTextLocator(this));
            } else {
                this.fLocator = new OffsetLocator(this.fParent.connectedTextLocator(this));
            }
            this.updateLocation();
        }
        return true;
    }

    @Override
    public ParentFigure parent() {
        return this.fParent;
    }

    @Override
    public void updateLocation() {
        if (this.fLocator != null) {
            Point point = this.fLocator.locate(this.fParent);
            point.x -= this.size().width / 2 + this.fOriginX;
            point.y -= this.size().height / 2 + this.fOriginY;
            if (point.x != 0 || point.y != 0) {
                this.willChange();
                this.basicMoveBy(point.x, point.y);
                this.changed();
            }
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.fParent != null) {
            this.fParent.removeChild(this);
        }
    }

    public static Font createCurrentFont() {
        return Fontkit.getFont(fgCurrentFontName, fgCurrentFontStyle, fgCurrentFontSize);
    }

    public static void setCurrentFontName(String string) {
        fgCurrentFontName = string;
    }

    public static void setCurrentFontSize(int n) {
        fgCurrentFontSize = n;
    }

    public static void setCurrentFontStyle(int n) {
        fgCurrentFontStyle = n;
    }

    @Override
    public void figureChanged(FigureChangeEvent figureChangeEvent) {
        this.updateLocation();
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        FigureEnumeration figureEnumeration = super.getFiguresWithDependencies();
        Vector<Figure> vector = new Vector<Figure>(1);
        vector.addElement(this.parent());
        return new MergedFigureEnumerator(figureEnumeration, new FigureEnumerator(vector));
    }

    @Override
    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (!bl) {
            return super.inspect(drawingView, false);
        }
        if (this.acceptsTyping()) {
            ((DrawApplication)drawingView.editor()).doTextEdit(this);
            return true;
        }
        return false;
    }

    static {
        int n = GUIProperties.defaultFontSize();
        if (n != -1) {
            fgCurrentFontSize = n;
            logger.debug((Object)("Setting default font size to " + fgCurrentFontSize + " pt."));
        }
    }
}

