/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingTypeManagerListener;
import CH.ifa.draw.io.IFAFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.plugin.PluginManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DrawingTypeManager {
    public static Logger logger = Logger.getLogger(DrawingTypeManager.class);
    private static DrawingTypeManager dtm;
    private Hashtable<String, SimpleFileFilter> drawingTypes = new Hashtable();
    private SimpleFileFilter defaultFileFilter;
    private Set<DrawingTypeManagerListener> listeners = new HashSet<DrawingTypeManagerListener>();

    private DrawingTypeManager() {
    }

    public static DrawingTypeManager getInstance() {
        if (dtm == null) {
            dtm = new DrawingTypeManager();
            IFAFileFilter iFAFileFilter = new IFAFileFilter();
            dtm.register("CH.ifa.draw.standard.StandardDrawing", iFAFileFilter);
            dtm.setDefaultFileFilter(iFAFileFilter);
            return dtm;
        }
        return dtm;
    }

    public Object register(String string, SimpleFileFilter simpleFileFilter) {
        logger.debug((Object)("DrawingTypeManager: registering " + simpleFileFilter + " for drawing type " + string));
        SimpleFileFilter simpleFileFilter2 = this.drawingTypes.put(string, simpleFileFilter);
        Iterator<DrawingTypeManagerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().typeRegistered(string, simpleFileFilter);
        }
        return simpleFileFilter2;
    }

    public static Drawing getDrawingFromName(String string) {
        Drawing drawing = null;
        try {
            drawing = (Drawing)Class.forName(string, true, PluginManager.getInstance().getBottomClassLoader()).newInstance();
        }
        catch (InstantiationException instantiationException) {
            logger.error((Object)instantiationException.getMessage(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.error((Object)illegalAccessException.getMessage(), (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
        }
        return drawing;
    }

    public static Drawing getDrawingForFilter(SimpleFileFilter simpleFileFilter) {
        Hashtable<String, SimpleFileFilter> hashtable = DrawingTypeManager.getInstance().getDrawingTypes();
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            SimpleFileFilter simpleFileFilter2 = hashtable.get(string);
            if (!simpleFileFilter2.equals(simpleFileFilter)) continue;
            return DrawingTypeManager.getDrawingFromName(string);
        }
        return null;
    }

    public Hashtable<String, SimpleFileFilter> getDrawingTypes() {
        return this.drawingTypes;
    }

    public boolean contains(String string) {
        return this.drawingTypes.containsKey(string);
    }

    public SimpleFileFilter getFilter(String string) {
        return this.drawingTypes.get(string);
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return this.defaultFileFilter;
    }

    public void setDefaultFileFilter(SimpleFileFilter simpleFileFilter) {
        if (!this.drawingTypes.contains(simpleFileFilter)) {
            throw new IllegalArgumentException("Channot choose unknown drawing type as default: " + simpleFileFilter);
        }
        logger.debug((Object)("DrawingTypeManager: choosing " + simpleFileFilter + " as default drawing type."));
        this.defaultFileFilter = simpleFileFilter;
        Iterator<DrawingTypeManagerListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().defaultTypeChanged(simpleFileFilter);
        }
    }

    public void addListener(DrawingTypeManagerListener drawingTypeManagerListener) {
        this.listeners.add(drawingTypeManagerListener);
    }

    public void removeListener(DrawingTypeManagerListener drawingTypeManagerListener) {
        this.listeners.remove(drawingTypeManagerListener);
    }

    public void unregister(String string) {
        Enumeration<String> enumeration;
        logger.debug((Object)("DrawingTypeManager: unregistering  for drawing type " + string));
        this.drawingTypes.remove(string);
        if (string.equals(this.defaultFileFilter.getDescription())) {
            enumeration = this.drawingTypes.keys();
            if (enumeration.hasMoreElements()) {
                SimpleFileFilter simpleFileFilter = this.drawingTypes.get(enumeration.nextElement());
                this.setDefaultFileFilter(simpleFileFilter);
            } else {
                this.defaultFileFilter = null;
            }
        }
        enumeration = this.listeners.iterator();
        while (enumeration.hasNext()) {
            ((DrawingTypeManagerListener)enumeration.next()).defaultTypeChanged(this.defaultFileFilter);
        }
    }
}

