/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.io.SimpleFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Iterator;

public class CombinationFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private HashSet<SimpleFileFilter> filterList;
    private SimpleFileFilter preferedFileFilter;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public CombinationFileFilter(String string) {
        this.setDescription(string);
        this.filterList = new HashSet();
    }

    private void setDescription(String string) {
        this.description = string;
    }

    public boolean add(SimpleFileFilter simpleFileFilter) {
        boolean bl = false;
        if (!this.contains(simpleFileFilter)) {
            if (this.filterList.isEmpty()) {
                this.preferedFileFilter = simpleFileFilter;
            }
            bl = this.filterList.add(simpleFileFilter);
        }
        return bl;
    }

    public boolean contains(SimpleFileFilter simpleFileFilter) {
        boolean bl = false;
        for (SimpleFileFilter simpleFileFilter2 : this.filterList) {
            if (simpleFileFilter == null || !simpleFileFilter.equals(simpleFileFilter2)) continue;
            bl = true;
        }
        return bl;
    }

    public void remove(SimpleFileFilter simpleFileFilter) {
        this.filterList.remove(simpleFileFilter);
    }

    public HashSet<SimpleFileFilter> getFileFilters() {
        return this.filterList;
    }

    public String getExtension() {
        return this.getPreferedFileFilter().getExtension();
    }

    public void allowHidden(boolean bl) {
        this.allowHidden = bl;
    }

    public void allowDirectory(boolean bl) {
        this.allowDirectory = bl;
    }

    public boolean isHiddenAllowed() {
        return this.allowHidden;
    }

    public boolean isDirectoryAllowed() {
        return this.allowDirectory;
    }

    @Override
    public boolean accept(File file) {
        if (file != null && (this.allowHidden || !file.isHidden() && !file.getName().startsWith("."))) {
            if (file.isDirectory()) {
                return this.allowDirectory;
            }
            Iterator<SimpleFileFilter> iterator = this.filterList.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().accept(file)) continue;
                return true;
            }
        }
        return false;
    }

    public SimpleFileFilter getPreferedFileFilter() {
        return this.preferedFileFilter;
    }

    public void setPreferedFileFilter(SimpleFileFilter simpleFileFilter) {
        this.preferedFileFilter = simpleFileFilter;
    }

    public boolean isEmpty() {
        return this.filterList.isEmpty();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

