/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.CombinationFileFilter;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolder;
import CH.ifa.draw.io.NoFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import CH.ifa.draw.io.exportFormats.ExportFormatCommand;
import CH.ifa.draw.io.exportFormats.ExportFormatMulti;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class ExportHolderImpl
implements ExportHolder {
    public static Logger logger = Logger.getLogger(ExportHolderImpl.class);
    private CommandMenu exportMenu = new CommandMenu("Export");
    private List<ExportFormat> _exportFormats;
    private CommandMenu _exportMenu11;
    private CommandMenu _exportMenuNN;
    private CommandMenu _exportMenuN1;

    public ExportHolderImpl() {
        this.exportMenu.putClientProperty("ch.ifa.draw.menu.id", "ch.ifa.draw.io.export");
        this.initExportFormatHolder();
        this.createDefaultExportFormats();
    }

    private StatusDisplayer displayer() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        return drawApplication;
    }

    private DrawApplication application() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        return drawApplication;
    }

    public JMenu getExportMenu() {
        return this.exportMenu();
    }

    private void initExportFormatHolder() {
        this.setExportFormats(new LinkedList<ExportFormat>());
        this.setExportMenu11(new CommandMenu("Export current drawing"));
        this.setExportMenuNN(new CommandMenu("Export all drawings (single file each)"));
        this.setExportMenuN1(new CommandMenu("Export all drawings (merged file)"));
        this.buildExportAll();
        this.exportMenu.add(this.exportMenu11());
        this.exportMenu.add(this.exportMenuNN());
        this.exportMenu.add(this.exportMenuN1());
    }

    private List<ExportFormat> exportFormats() {
        List<ExportFormat> list = null;
        list = this._exportFormats;
        assert (list != null) : "Failure in GuiPlugin: result == null";
        return list;
    }

    private void setExportFormats(List<ExportFormat> list) {
        this._exportFormats = list;
        assert (this.exportFormats() != null) : "Failure in GuiPlugin: exportFormats == null";
        assert (((Object)this.exportFormats()).equals(list)) : "Failure in GuiPlugin: exportFormats != exportFormats()";
    }

    private CommandMenu exportMenu() {
        CommandMenu commandMenu = null;
        commandMenu = this.exportMenu;
        assert (commandMenu != null) : "Failure in GuiPlugin: result == null";
        return commandMenu;
    }

    private CommandMenu exportMenu11() {
        CommandMenu commandMenu = null;
        commandMenu = this._exportMenu11;
        assert (commandMenu != null) : "Failure in GuiPlugin: result == null";
        return commandMenu;
    }

    private void setExportMenu11(CommandMenu commandMenu) {
        this._exportMenu11 = commandMenu;
        assert (this.exportMenu11() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenu11().equals(commandMenu)) : "Failure in GuiPlugin: exportMenu != exportMenu()";
    }

    private CommandMenu exportMenuNN() {
        CommandMenu commandMenu = null;
        commandMenu = this._exportMenuNN;
        assert (commandMenu != null) : "Failure in GuiPlugin: result == null";
        return commandMenu;
    }

    private void setExportMenuNN(CommandMenu commandMenu) {
        this._exportMenuNN = commandMenu;
        assert (this.exportMenuNN() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenuNN().equals(commandMenu)) : "Failure in GuiPlugin: exportMenu != exportMenu()";
    }

    private CommandMenu exportMenuN1() {
        CommandMenu commandMenu = null;
        commandMenu = this._exportMenuN1;
        assert (commandMenu != null) : "Failure in GuiPlugin: result == null";
        return commandMenu;
    }

    private void setExportMenuN1(CommandMenu commandMenu) {
        this._exportMenuN1 = commandMenu;
        assert (this.exportMenuN1() != null) : "Failure in GuiPlugin: exportMenu == null";
        assert (this.exportMenuN1().equals(commandMenu)) : "Failure in GuiPlugin: exportMenu != exportMenu()";
    }

    /*
     * WARNING - void declaration
     */
    private SimpleFileFilter[] fileFilterExport(Drawing drawing) {
        void var7_10;
        SimpleFileFilter[] simpleFileFilterArray = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        ExportFormat[] exportFormatArray = this.allExportFormats();
        for (int i = 0; i < exportFormatArray.length; ++i) {
            if (!exportFormatArray[i].canExportDrawing(drawing)) continue;
            FileFilter[] fileFilterArray = this.buildFileFilter(exportFormatArray[i]);
            linkedList.add(fileFilterArray);
        }
        LinkedList<SimpleFileFilter> linkedList2 = new LinkedList<SimpleFileFilter>();
        linkedList2.add(new NoFileFilter());
        for (FileFilter[] fileFilterArray : linkedList) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                SimpleFileFilter simpleFileFilter = (SimpleFileFilter)fileFilterArray[i];
                boolean bl = false;
                for (int j = 0; j <= i && !(bl = ((SimpleFileFilter)linkedList2.get(j)).equals(simpleFileFilter)); ++j) {
                }
                if (bl) continue;
                linkedList2.add(simpleFileFilter);
            }
        }
        simpleFileFilterArray = new SimpleFileFilter[linkedList2.size()];
        boolean i = false;
        while (var7_10 < linkedList2.size()) {
            simpleFileFilterArray[var7_10] = (SimpleFileFilter)linkedList2.get((int)var7_10);
            ++var7_10;
        }
        return simpleFileFilterArray;
    }

    private FileFilter[] buildFileFilter(ExportFormat exportFormat) {
        FileFilter[] fileFilterArray = null;
        FileFilter fileFilter = exportFormat.fileFilter();
        LinkedList<FileFilter> linkedList = new LinkedList<FileFilter>();
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter combinationFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : combinationFileFilter.getFileFilters()) {
                linkedList.add(fileFilter2);
            }
        } else {
            linkedList.add(fileFilter);
        }
        fileFilterArray = new FileFilter[linkedList.size()];
        for (int i = 0; i < fileFilterArray.length; ++i) {
            fileFilterArray[i] = (FileFilter)linkedList.get(i);
        }
        return fileFilterArray;
    }

    private void buildExportAll() {
        Command command = new Command("Export current drawing (any type)..."){

            @Override
            public void execute() {
                if (!(ExportHolderImpl.this.application().drawing() instanceof NullDrawing)) {
                    File file = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, ExportHolderImpl.this.fileFilterExport(ExportHolderImpl.this.application().drawing()), ExportHolderImpl.this.application().drawing());
                    if (file != null) {
                        Object object;
                        Object object2;
                        ExportFormat[] exportFormatArray;
                        LinkedList<ExportFormat[]> linkedList = new LinkedList<ExportFormat[]>();
                        for (int i = 0; i < ExportHolderImpl.this.allExportFormats().length; ++i) {
                            exportFormatArray = ExportHolderImpl.this.allExportFormats()[i].canExport(file);
                            if (exportFormatArray.length <= 0) continue;
                            linkedList.add(exportFormatArray);
                        }
                        Iterator iterator = linkedList.iterator();
                        exportFormatArray = new LinkedList();
                        while (iterator.hasNext()) {
                            object2 = (ExportFormat[])iterator.next();
                            for (int i = 0; i < ((ExportFormat[])object2).length; ++i) {
                                if (!object2[i].canExportDrawing(ExportHolderImpl.this.application().drawing())) continue;
                                if (new NoFileFilter().equals((SimpleFileFilter)object2[i].fileFilter())) {
                                    if (!StringUtil.getExtension((String)file.getPath()).equals("")) continue;
                                    exportFormatArray.add(object2[i]);
                                    continue;
                                }
                                exportFormatArray.add(object2[i]);
                            }
                        }
                        object2 = null;
                        if (exportFormatArray.size() == 1) {
                            object2 = (ExportFormat)exportFormatArray.get(0);
                        } else if (exportFormatArray.size() > 1 && (object = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, exportFormatArray.toArray(), exportFormatArray.get(0))) != null) {
                            object2 = (ExportFormat)object;
                        }
                        if (object2 != null) {
                            ExportHolderImpl.this.saveDrawing(ExportHolderImpl.this.application().drawing(), (ExportFormat)object2, file);
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no ExportFormat");
                        }
                    }
                } else {
                    ExportHolderImpl.this.displayer().showStatus("no drawing");
                }
            }

            @Override
            public boolean isExecutable() {
                if (!super.isExecutable()) {
                    return false;
                }
                boolean bl = false;
                if (ExportHolderImpl.this.application() != null) {
                    bl = !(ExportHolderImpl.this.application().drawing() instanceof NullDrawing);
                }
                return bl;
            }
        };
        this.exportMenu.add(command);
    }

    private void saveDrawings(Enumeration<Drawing> enumeration, ExportFormat exportFormat, File file) {
        try {
            Drawing[] drawingArray;
            LinkedList<Drawing[]> linkedList = new LinkedList<Drawing[]>();
            while (enumeration.hasMoreElements()) {
                drawingArray = enumeration.nextElement();
                linkedList.add(drawingArray);
            }
            drawingArray = new Drawing[linkedList.size()];
            for (int i = 0; i < drawingArray.length; ++i) {
                drawingArray[i] = (Drawing)linkedList.get(i);
            }
            exportFormat.export(drawingArray, file);
            this.displayer().showStatus("Exported " + file.getPath() + ".");
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.displayer().showStatus(exception.toString());
        }
    }

    private void saveDrawings(Enumeration<Drawing> enumeration, ExportFormat exportFormat) {
        try {
            Drawing[] drawingArray;
            LinkedList<Drawing[]> linkedList = new LinkedList<Drawing[]>();
            while (enumeration.hasMoreElements()) {
                drawingArray = enumeration.nextElement();
                if (drawingArray.getFilename() == null) {
                    this.application().saveDrawingAs((Drawing)drawingArray);
                }
                if (drawingArray.getFilename() == null) continue;
                linkedList.add(drawingArray);
            }
            drawingArray = new Drawing[linkedList.size()];
            File[] fileArray = new File[drawingArray.length];
            for (int i = 0; i < drawingArray.length; ++i) {
                drawingArray[i] = (Drawing)linkedList.get(i);
                String string = drawingArray[i].getName();
                File file = drawingArray[i].getFilename();
                file = file.getCanonicalFile();
                String string2 = file.getParent() + File.separator + string;
                fileArray[i] = DrawingFileHelper.checkAndAddExtension(new File(string2), (SimpleFileFilter)exportFormat.fileFilter());
            }
            if (drawingArray.length > 0) {
                exportFormat.exportAll(drawingArray, fileArray);
                this.displayer().showStatus("Exported.");
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.displayer().showStatus(exception.toString());
        }
    }

    public void saveDrawing(Drawing drawing, ExportFormat exportFormat, File file, StatusDisplayer statusDisplayer) {
        try {
            File file2 = exportFormat.export(drawing, file);
            statusDisplayer.showStatus("Exported " + file2.getPath() + ".");
        }
        catch (Exception exception) {
            statusDisplayer.showStatus(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void saveDrawing(Drawing drawing, ExportFormat exportFormat, File file) {
        try {
            File file2 = exportFormat.export(drawing, file);
            this.displayer().showStatus("Exported " + file2.getPath() + ".");
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            this.displayer().showStatus(exception.toString());
        }
    }

    private void buildExportFormat(ExportFormat exportFormat, CommandMenu commandMenu, CommandMenu commandMenu2, CommandMenu commandMenu3) {
        if (exportFormat instanceof ExportFormatMulti) {
            ExportFormatMulti exportFormatMulti = (ExportFormatMulti)exportFormat;
            ExportFormat[] exportFormatArray = exportFormatMulti.allExportFormats();
            CommandMenu commandMenu4 = new CommandMenu(exportFormatMulti.formatName());
            CommandMenu commandMenu5 = new CommandMenu(exportFormatMulti.formatName());
            CommandMenu commandMenu6 = new CommandMenu(exportFormatMulti.formatName());
            for (int i = 0; i < exportFormatArray.length; ++i) {
                this.buildExportFormat(exportFormatArray[i], commandMenu4, commandMenu5, commandMenu6);
            }
            commandMenu.add(commandMenu4);
            commandMenu.addSeparator();
            commandMenu2.add(commandMenu5);
            commandMenu2.addSeparator();
            commandMenu3.add(commandMenu6);
            commandMenu3.addSeparator();
        } else {
            this.generateCommands(exportFormat, commandMenu, commandMenu2, commandMenu3);
        }
    }

    private void generateCommands(ExportFormat exportFormat, CommandMenu commandMenu, CommandMenu commandMenu2, CommandMenu commandMenu3) {
        ExportFormatCommand exportFormatCommand = null;
        ExportFormatCommand exportFormatCommand2 = null;
        ExportFormatCommand exportFormatCommand3 = null;
        exportFormatCommand = this.generateExportCommand1to1(exportFormat);
        if (exportFormat.getShortCut() == -1) {
            commandMenu.add(exportFormatCommand);
        } else if (exportFormat.getModifier() == -1) {
            commandMenu.add(exportFormatCommand, exportFormat.getShortCut());
        } else {
            commandMenu.add(exportFormatCommand, exportFormat.getShortCut(), exportFormat.getModifier());
        }
        exportFormatCommand3 = this.generateExportCommandNtoN(exportFormat);
        commandMenu2.add(exportFormatCommand3);
        if (exportFormat.canExportNto1()) {
            exportFormatCommand2 = this.generateExportCommandNto1(exportFormat);
            commandMenu3.add(exportFormatCommand2);
        }
    }

    private ExportFormatCommand generateExportCommand1to1(ExportFormat exportFormat) {
        ExportFormatCommand exportFormatCommand = null;
        if (exportFormat != null) {
            exportFormatCommand = new ExportFormatCommand(exportFormat, " current drawing ..."){

                @Override
                public void execute() {
                    Drawing drawing = ExportHolderImpl.this.application().drawing();
                    if (drawing != null) {
                        if (!(drawing instanceof NullDrawing)) {
                            if (this.format().forceGivenName()) {
                                if (drawing.getFilename() != null) {
                                    try {
                                        String string = drawing.getFilename().getCanonicalPath() + drawing.getName();
                                        string = StringUtil.getPath((String)string) + File.separator + drawing.getName();
                                        File file = new File(string);
                                        ExportHolderImpl.this.saveDrawing(drawing, this.format(), file);
                                    }
                                    catch (IOException iOException) {
                                        logger.error((Object)"Could not create export file: ");
                                        logger.debug((Object)"Could not create export file: ", (Throwable)iOException);
                                    }
                                }
                            } else {
                                File file = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, new SimpleFileFilter[]{(SimpleFileFilter)this.format().fileFilter()}, drawing);
                                if (file != null) {
                                    ExportHolderImpl.this.displayer().showStatus("Exporting " + file + " ...");
                                    ExportHolderImpl.this.saveDrawing(drawing, this.format(), file);
                                }
                            }
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    } else {
                        ExportHolderImpl.this.displayer().showStatus("no drawing");
                    }
                    ExportHolderImpl.this.application().toolDone();
                }

                @Override
                public boolean isExecutable() {
                    boolean bl = false;
                    if (ExportHolderImpl.this.application() != null && !(ExportHolderImpl.this.application().drawing() instanceof NullDrawing) && this.format().canExportDrawing(ExportHolderImpl.this.application().drawing())) {
                        bl = true;
                    }
                    return bl;
                }
            };
        }
        assert (exportFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return exportFormatCommand;
    }

    private ExportFormatCommand generateExportCommandNto1(ExportFormat exportFormat) {
        ExportFormatCommand exportFormatCommand = null;
        if (exportFormat != null) {
            exportFormatCommand = new ExportFormatCommand(exportFormat, " all drawings (N to 1) ..."){

                @Override
                public void execute() {
                    Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                    if (enumeration != null) {
                        if (enumeration.hasMoreElements()) {
                            File file = DrawPlugin.getCurrent().getIOHelper().getSaveFile(null, new SimpleFileFilter[]{(SimpleFileFilter)this.format().fileFilter()}, enumeration.nextElement());
                            if (file != null) {
                                ExportHolderImpl.this.displayer().showStatus("Exporting " + file + " ...");
                                ExportHolderImpl.this.saveDrawings(ExportHolderImpl.this.application().drawings(), this.format(), file);
                            }
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    }
                    ExportHolderImpl.this.application().toolDone();
                    ExportHolderImpl.this.displayer().showStatus("export");
                }

                @Override
                public boolean isExecutable() {
                    boolean bl = true;
                    if (ExportHolderImpl.this.application() == null) {
                        return false;
                    }
                    if (!(ExportHolderImpl.this.application().drawing() instanceof NullDrawing)) {
                        Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                        while (enumeration.hasMoreElements()) {
                            Drawing drawing = enumeration.nextElement();
                            if (this.format().canExportDrawing(drawing)) continue;
                            bl = false;
                            break;
                        }
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            };
        }
        assert (exportFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return exportFormatCommand;
    }

    private ExportFormatCommand generateExportCommandNtoN(ExportFormat exportFormat) {
        ExportFormatCommand exportFormatCommand = null;
        if (exportFormat != null) {
            exportFormatCommand = new ExportFormatCommand(exportFormat, " all drawings (N to N)"){

                @Override
                public void execute() {
                    ExportHolderImpl.this.displayer().showStatus("Exporting  ...");
                    Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                    if (enumeration != null) {
                        if (enumeration.hasMoreElements()) {
                            ExportHolderImpl.this.saveDrawings(enumeration, this.format());
                        } else {
                            ExportHolderImpl.this.displayer().showStatus("no drawing");
                        }
                    }
                    ExportHolderImpl.this.application().toolDone();
                    ExportHolderImpl.this.displayer().showStatus("export");
                }

                @Override
                public boolean isExecutable() {
                    boolean bl = true;
                    if (ExportHolderImpl.this.application() == null) {
                        return false;
                    }
                    if (!(ExportHolderImpl.this.application().drawing() instanceof NullDrawing)) {
                        Enumeration<Drawing> enumeration = ExportHolderImpl.this.application().drawings();
                        while (enumeration.hasMoreElements()) {
                            Drawing drawing = enumeration.nextElement();
                            if (this.format().canExportDrawing(drawing)) continue;
                            bl = false;
                            break;
                        }
                    } else {
                        bl = false;
                    }
                    return bl;
                }
            };
        }
        assert (exportFormatCommand != null) : "Failure in GuiPlugin: result == null";
        return exportFormatCommand;
    }

    @Override
    public void addExportFormat(ExportFormat exportFormat) {
        logger.debug((Object)(this.getClass() + ": adding export format " + exportFormat));
        this.exportFormats().add(exportFormat);
        this.buildExportFormat(exportFormat, this.exportMenu11(), this.exportMenuNN(), this.exportMenuN1());
    }

    @Override
    public ExportFormat[] allExportFormats() {
        ExportFormat[] exportFormatArray = null;
        exportFormatArray = new ExportFormat[this.exportFormats().size()];
        for (int i = 0; i < exportFormatArray.length; ++i) {
            exportFormatArray[i] = this.exportFormats().get(i);
        }
        assert (exportFormatArray != null) : "Failure in GuiPlugin: result == null";
        return exportFormatArray;
    }

    @Override
    public void removeExportFormat(ExportFormat exportFormat) {
        Component[] componentArray = this.exportMenu().getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (!(componentArray[i] instanceof JMenuItem) || !(jMenuItem = (JMenuItem)componentArray[i]).getText().equals(exportFormat.formatName())) continue;
            this.exportMenu().remove(jMenuItem);
        }
        this.exportFormats().remove(exportFormat);
    }

    private void createDefaultExportFormats() {
    }
}

