/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import java.io.File;
import java.io.FileFilter;

public abstract class SimpleFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private String ext;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public void allowHidden(boolean bl) {
        this.allowHidden = bl;
    }

    public void allowDirectory(boolean bl) {
        this.allowDirectory = bl;
    }

    public boolean isHiddenAllowed() {
        return this.allowHidden;
    }

    public boolean isDirectoryAllowed() {
        return this.allowDirectory;
    }

    @Override
    public boolean accept(File file) {
        if (file != null && (this.allowHidden || !file.isHidden() && !file.getName().startsWith("."))) {
            if (file.isDirectory()) {
                return this.allowDirectory;
            }
            String string = this.getExtension(file);
            if (string != null && this.ext.equals(string)) {
                return true;
            }
        }
        return false;
    }

    protected String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getExtension() {
        return this.ext;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setExtension(String string) {
        this.ext = string;
    }

    public boolean equals(SimpleFileFilter simpleFileFilter) {
        return simpleFileFilter != null && simpleFileFilter.getExtension().equals(this.getExtension());
    }
}

