/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.PositionedDrawing;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.util.StorableInput;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class StorableInputDrawingLoader {
    protected StorableInput makeStorableInput(URL uRL, boolean bl) throws IOException {
        return new StorableInput(uRL, bl);
    }

    protected StorableInput makeStorableInput(InputStream inputStream, boolean bl) {
        return new StorableInput(inputStream, bl);
    }

    public PositionedDrawing readFromStorableInput(File file, StatusDisplayer statusDisplayer) throws IOException {
        try {
            return this.readFromStorableInput(file.toURI().toURL(), statusDisplayer);
        }
        catch (MalformedURLException malformedURLException) {
            statusDisplayer.showStatus("Error " + malformedURLException);
            return null;
        }
    }

    public PositionedDrawing readFromStorableInput(InputStream inputStream) throws FileNotFoundException, IOException {
        StorableInput storableInput = null;
        storableInput = this.makeStorableInput(inputStream, true);
        return this.readFromStorableInput(storableInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PositionedDrawing readFromStorableInput(URL uRL, StatusDisplayer statusDisplayer) throws IOException {
        StorableInput storableInput = null;
        try {
            storableInput = this.makeStorableInput(uRL, true);
            PositionedDrawing positionedDrawing = this.readFromStorableInput(storableInput, statusDisplayer);
            return positionedDrawing;
        }
        catch (IOException iOException) {
            storableInput = this.makeStorableInput(uRL, false);
            PositionedDrawing positionedDrawing = this.readFromStorableInput(storableInput, statusDisplayer);
            return positionedDrawing;
        }
        finally {
            if (storableInput != null) {
                storableInput.close();
            }
        }
    }

    private PositionedDrawing readFromStorableInput(StorableInput storableInput, StatusDisplayer statusDisplayer) {
        Drawing drawing = null;
        Point point = null;
        Dimension dimension = null;
        try {
            drawing = StorableInputDrawingLoader.readStorableDrawing(storableInput);
            if (storableInput.canReadInt()) {
                point = new Point(storableInput.readInt(), storableInput.readInt());
                dimension = new Dimension(storableInput.readInt(), storableInput.readInt());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            statusDisplayer.showStatus("Error: File not found. " + fileNotFoundException);
        }
        catch (IOException iOException) {
            statusDisplayer.showStatus("Error " + iOException);
        }
        if (drawing == null) {
            return null;
        }
        return new PositionedDrawing(point, dimension, drawing);
    }

    private PositionedDrawing readFromStorableInput(StorableInput storableInput) throws FileNotFoundException, IOException {
        Drawing drawing = null;
        Point point = null;
        Dimension dimension = null;
        try {
            drawing = StorableInputDrawingLoader.readStorableDrawing(storableInput);
            if (storableInput.canReadInt()) {
                point = new Point(storableInput.readInt(), storableInput.readInt());
                dimension = new Dimension(storableInput.readInt(), storableInput.readInt());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "StorableInputDrawingLoader.readFromStorableInput : Error: File not found. " + fileNotFoundException;
            throw new FileNotFoundException(string);
        }
        catch (IOException iOException) {
            String string = "StorableInputDrawingLoader.readFromStorableInput : Error " + iOException;
            throw new IOException(string);
        }
        if (drawing == null) {
            return null;
        }
        return new PositionedDrawing(point, dimension, drawing);
    }

    public static Drawing readStorableDrawing(StorableInput storableInput) throws IOException {
        if (storableInput.canReadInt()) {
            storableInput.setVersion(storableInput.readInt());
        } else {
            storableInput.setVersion(0);
        }
        return (Drawing)storableInput.readStorable();
    }
}

