/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.exportFormats.ExportFormat;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public abstract class ExportFormatAbstract
implements ExportFormat {
    private String _formatName;
    private FileFilter _fileFilter;

    public ExportFormatAbstract(String string, FileFilter fileFilter) {
        this.setFormatName(string);
        this.setFileFilter(fileFilter);
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
        assert (this.fileFilter() != null) : "Failure in ExportFormatAbstract: fileFilter() == null";
        assert (this.fileFilter().equals(fileFilter)) : "Failure in ExportFormatAbstract: fileFilter() != fileFilter";
    }

    protected void setFormatName(String string) {
        this._formatName = string;
        assert (this.formatName() != null) : "Failure in ExportFormatAbstract: formatName() == null";
        assert (this.formatName().equals(string)) : "Failure in ExportFormatAbstract: formatName() != fielFilter";
    }

    @Override
    public FileFilter fileFilter() {
        FileFilter fileFilter = null;
        fileFilter = this._fileFilter;
        assert (fileFilter != null) : "Failure in ExportFormatAbstract: result == null";
        return fileFilter;
    }

    @Override
    public String formatName() {
        String string = null;
        string = this._formatName;
        assert (string != null) : "Failure in ExportFormatAbstract: result == null";
        return string;
    }

    @Override
    public File[] exportAll(Drawing[] drawingArray, File[] fileArray) throws Exception {
        File[] fileArray2 = null;
        if (drawingArray != null && fileArray != null && drawingArray.length == fileArray.length) {
            fileArray2 = new File[fileArray.length];
            for (int i = 0; i < drawingArray.length; ++i) {
                fileArray2[i] = this.export(drawingArray[i], fileArray[i]);
            }
        }
        assert (fileArray2 != null) : "Failure in ExportFormatAbstract : result == null";
        return fileArray2;
    }

    @Override
    public ExportFormat[] canExport(File file) {
        ExportFormat[] exportFormatArray = null;
        if (file != null) {
            exportFormatArray = this.fileFilter().accept(file) ? new ExportFormat[]{this} : new ExportFormat[]{};
        }
        assert (exportFormatArray != null) : "Failure in ExportFormatAbstract: result == null";
        return exportFormatArray;
    }

    @Override
    public int getShortCut() {
        return -1;
    }

    @Override
    public int getModifier() {
        return -1;
    }

    @Override
    public boolean forceGivenName() {
        return false;
    }

    public String toString() {
        String string = "";
        string = this.formatName();
        return string;
    }
}

