/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Decorable;
import CH.ifa.draw.framework.Decoration;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.ChopBoxConnector;
import CH.ifa.draw.standard.FigureChangeEventMulticaster;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class AbstractFigure
implements ParentFigure,
Decorable {
    public static Logger logger = Logger.getLogger(AbstractFigure.class);
    private static final long serialVersionUID = -10857585979273442L;
    private transient FigureChangeListener fListener;
    private int abstractFigureSerializedDataVersion = 1;
    private boolean fVisible = true;
    protected transient Vector<Figure> children = new Vector();
    protected Vector<Decoration> decorations = new Vector();

    protected AbstractFigure() {
    }

    @Override
    public void draw(Graphics graphics, DrawingContext drawingContext) {
        if (drawingContext.isVisible(this)) {
            this.draw(graphics);
            this.drawDecorations(graphics);
        }
    }

    @Override
    public void drawDecorations(Graphics graphics) {
        logger.debug((Object)("[AbstractFigure.drawDecorations] decorations Vector " + (this.decorations.isEmpty() ? " is empty." : " has Elements ")));
        if (!this.decorations.isEmpty()) {
            Decoration decoration = this.decorations.firstElement();
            logger.debug((Object)("[AbstractFigure.drawDecorations] Drawing the decoration " + decoration));
            decoration.draw(graphics, this.displayBox());
        }
    }

    @Override
    public List<Decoration> getDecorations() {
        return this.decorations;
    }

    @Override
    public boolean isDecorated() {
        return !this.decorations.isEmpty();
    }

    @Override
    public void addDecoration(Decoration decoration) {
        if (this.decorations != null) {
            this.decorations.addElement(decoration);
        } else {
            logger.error((Object)"[AbstractFigure.addDecoration(): field decorations is null");
        }
    }

    @Override
    public void removeDecoration(Decoration decoration) {
        if (this.decorations != null) {
            this.decorations.removeElement(decoration);
        } else {
            logger.error((Object)"[AbstractFigure.removeDecoration(): field decorations is null");
        }
    }

    @Override
    public void moveBy(int n, int n2) {
        this.willChange();
        this.basicMoveBy(n, n2);
        FigureEnumeration figureEnumeration = this.children();
        while (figureEnumeration.hasMoreElements()) {
            ((ChildFigure)figureEnumeration.nextElement()).updateLocation();
        }
        this.changed();
    }

    protected abstract void basicMoveBy(int var1, int var2);

    @Override
    public void displayBox(Point point, Point point2) {
        this.willChange();
        this.basicDisplayBox(point, point2);
        this.changed();
    }

    @Override
    public abstract void basicDisplayBox(Point var1, Point var2);

    @Override
    public abstract Rectangle displayBox();

    @Override
    public abstract Vector<Handle> handles();

    @Override
    public FigureEnumeration figures() {
        Vector<Figure> vector = new Vector<Figure>(1);
        vector.addElement(this);
        return new FigureEnumerator(vector);
    }

    @Override
    public Dimension size() {
        Rectangle rectangle = this.displayBox();
        return new Dimension(rectangle.width, rectangle.height);
    }

    @Override
    public boolean isEmpty() {
        return this.size().width < 3 || this.size().height < 3;
    }

    @Override
    public Figure findFigureInside(int n, int n2) {
        if (this.containsPoint(n, n2)) {
            return this;
        }
        return null;
    }

    @Override
    public boolean containsPoint(int n, int n2) {
        if (this.isVisible()) {
            return this.displayBox().contains(n, n2);
        }
        return false;
    }

    @Override
    public void displayBox(Rectangle rectangle) {
        this.displayBox(new Point(rectangle.x, rectangle.y), new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
    }

    @Override
    public boolean includes(Figure figure) {
        return figure == this;
    }

    @Override
    public FigureEnumeration decompose() {
        Vector<Figure> vector = new Vector<Figure>(1);
        vector.addElement(this);
        return new FigureEnumerator(vector);
    }

    @Override
    public void addToContainer(FigureChangeListener figureChangeListener) {
        this.addFigureChangeListener(figureChangeListener);
        this.invalidate();
    }

    @Override
    public void removeFromContainer(FigureChangeListener figureChangeListener) {
        this.invalidate();
        this.removeFigureChangeListener(figureChangeListener);
        this.changed();
    }

    @Override
    public void addFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.add(this.fListener, figureChangeListener);
    }

    @Override
    public void removeFigureChangeListener(FigureChangeListener figureChangeListener) {
        this.fListener = FigureChangeEventMulticaster.remove(this.fListener, figureChangeListener);
    }

    @Override
    public FigureChangeListener listener() {
        return this.fListener;
    }

    @Override
    public void release() {
        if (this.fListener != null) {
            this.fListener.figureRemoved(new FigureChangeEvent(this));
        }
    }

    @Override
    public void invalidate() {
        if (this.fListener != null) {
            Rectangle rectangle = this.displayBox();
            rectangle.grow(8, 8);
            this.fListener.figureInvalidated(new FigureChangeEvent(this, rectangle));
        }
    }

    @Override
    public void willChange() {
        this.invalidate();
    }

    @Override
    public void changed() {
        this.invalidate();
        if (this.fListener != null) {
            this.fListener.figureChanged(new FigureChangeEvent(this));
        }
    }

    public void handlesChanged() {
        if (this.fListener != null) {
            this.fListener.figureHandlesChanged(new FigureChangeEvent(this));
        }
    }

    @Override
    public Point center() {
        return Geom.center(this.displayBox());
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public Insets connectionInsets() {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Connector connectorAt(int n, int n2) {
        return new ChopBoxConnector(this);
    }

    @Override
    public Connector connectorAt(Point point) {
        return this.connectorAt(point.x, point.y);
    }

    @Override
    public void connectorVisibility(boolean bl) {
    }

    @Override
    public Locator connectedTextLocator(Figure figure) {
        return RelativeLocator.center();
    }

    @Override
    public Object getAttribute(String string) {
        if ("Visibility".equals(string)) {
            return new Boolean(this.isVisible());
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("Visibility".equals(string)) {
            this.setVisible((Boolean)object);
        }
    }

    @Override
    public Object clone() {
        Closeable closeable;
        Object object = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
        try {
            closeable = new ObjectOutputStream(byteArrayOutputStream);
            closeable.writeObject(this);
            closeable.close();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)closeable);
            object = objectInputStream.readObject();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.error((Object)classNotFoundException.getMessage(), (Throwable)classNotFoundException);
        }
        return object;
    }

    @Override
    public void write(StorableOutput storableOutput) {
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.children = new Vector();
    }

    @Override
    public FigureEnumeration children() {
        return new FigureEnumerator(this.children);
    }

    @Override
    public void addChild(ChildFigure childFigure) {
        this.children.addElement(childFigure);
        this.addFigureChangeListener(childFigure);
    }

    @Override
    public void removeChild(ChildFigure childFigure) {
        this.children.removeElement(childFigure);
        this.removeFigureChangeListener(childFigure);
    }

    private boolean selectAllChildren(DrawingView drawingView) {
        FigureEnumeration figureEnumeration = this.children();
        if (figureEnumeration.hasMoreElements()) {
            drawingView.clearSelection();
            drawingView.addToSelectionAll(figureEnumeration);
            return true;
        }
        return false;
    }

    @Override
    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            return false;
        }
        if (this instanceof ChildFigure) {
            ParentFigure parentFigure = ((ChildFigure)((Object)this)).parent();
            if (parentFigure != null) {
                drawingView.clearSelection();
                drawingView.addToSelection(parentFigure);
                return true;
            }
        } else {
            return this.selectAllChildren(drawingView);
        }
        return false;
    }

    @Override
    public FigureEnumeration getFiguresWithDependencies() {
        return this.children();
    }

    @Override
    public boolean isVisible() {
        return this.fVisible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.willChange();
        this.fVisible = bl;
        this.changed();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }
}

