/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.SnapToGridCommand;
import CH.ifa.draw.standard.SpreadCommand;
import CH.ifa.draw.standard.ToggleGridCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.CommandMenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenuItem;

public class AlignmentMenuCreator {
    public Collection<JMenuItem> createMenus() {
        MenuManager.SeparatorFactory separatorFactory = new MenuManager.SeparatorFactory("ch.ifa.draw");
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        vector.add(this.createCommandMenu(new ToggleGridCommand("Toggle Snap to Grid", new Point(5, 5))));
        vector.add(this.createCommandMenu(new SnapToGridCommand("Snap to Grid now", new Point(5, 5))));
        vector.add(separatorFactory.createSeparator());
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Align");
        commandMenu.add(new AlignCommand("Lefts", 0));
        commandMenu.add(new AlignCommand("Centers", 1), 92, n);
        commandMenu.add(new AlignCommand("Rights", 2));
        commandMenu.addSeparator();
        commandMenu.add(new AlignCommand("Tops", 3));
        commandMenu.add(new AlignCommand("Middles", 4), 45, n);
        commandMenu.add(new AlignCommand("Bottoms", 5));
        vector.add(commandMenu);
        CommandMenu commandMenu2 = DrawApplication.createCommandMenu("Spread");
        commandMenu2.add(new SpreadCommand("Lefts", 0));
        commandMenu2.add(new SpreadCommand("Centers", 1), 61, n);
        commandMenu2.add(new SpreadCommand("Rights", 2));
        commandMenu2.add(new SpreadCommand("Distances", 6));
        commandMenu2.addSeparator();
        commandMenu2.add(new SpreadCommand("Tops", 3));
        commandMenu2.add(new SpreadCommand("Middles", 4), 59, n);
        commandMenu2.add(new SpreadCommand("Bottoms", 5));
        commandMenu2.add(new SpreadCommand("Distances", 7));
        commandMenu2.addSeparator();
        commandMenu2.add(new SpreadCommand("Diagonal", 8), 47, n);
        vector.add(commandMenu2);
        vector.add(separatorFactory.createSeparator());
        vector.add(this.createCommandMenu(new SendToBackCommand("Send to Back"), 66));
        vector.add(this.createCommandMenu(new BringToFrontCommand("Bring to Front"), 66, n + 64));
        return vector;
    }

    private CommandMenuItem createCommandMenu(Command command) {
        return new CommandMenuItem(command);
    }

    private CommandMenuItem createCommandMenu(Command command, int n) {
        return new CommandMenuItem(command, n);
    }

    private CommandMenuItem createCommandMenu(Command command, int n, int n2) {
        return new CommandMenuItem(command, n, n2);
    }
}

