/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.AlphaChangeCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseColorCommand;
import CH.ifa.draw.standard.ChooseFontCommand;
import CH.ifa.draw.standard.QueryAttributeCommand;
import CH.ifa.draw.standard.SetLineWidthCommand;
import CH.ifa.draw.standard.SplineAttributeCommand;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.ExtendedFont;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class AttributesMenuCreator {
    private static final int MAX_FONT_MENU_ENTRIES = 30;

    public Collection<JMenuItem> createMenus() {
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        vector.add(this.createColorMenu("Fill Color", "FillColor"));
        vector.add(this.createTransparencyMenu("Fill Opacity", "FillColor"));
        vector.add(this.createColorMenu("Pen Color", "FrameColor"));
        vector.add(this.createTransparencyMenu("Pen Opacity", "FrameColor"));
        vector.add(this.createVisibilityMenu());
        vector.add(this.createArrowMenu());
        vector.add(this.createLineStyleMenu());
        vector.add(this.createLineShapeMenu());
        vector.add(this.createLineWidthMenu());
        vector.add(this.createArcScaleMenu());
        vector.add(new MenuManager.SeparatorFactory("ch.ifa.draw").createSeparator());
        vector.add(this.createFontMenu());
        vector.add(this.createFontSizeMenu());
        vector.add(this.createFontStyleMenu());
        vector.add(this.createTextAlignmentMenu());
        vector.add(this.createColorMenu("Text Color", "TextColor"));
        vector.add(this.createTransparencyMenu("Text Opacity", "TextColor"));
        return vector;
    }

    protected JMenu createColorMenu(String string, String string2) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu(string);
        for (int i = 0; i < ColorMap.size(); ++i) {
            commandMenu.add(new ChangeAttributeCommand(ColorMap.name(i), string2, ColorMap.color(i)));
        }
        commandMenu.add(new ChooseColorCommand(string, "other...", string2, Color.class));
        return commandMenu;
    }

    protected JMenu createTransparencyMenu(String string, String string2) {
        CommandMenu commandMenu = DrawApplication.createCommandMenu(string);
        for (int i = 10; i >= 0; --i) {
            commandMenu.add(new AlphaChangeCommand(i + "0%", string2, (int)Math.round((double)i * 25.5)));
        }
        return commandMenu;
    }

    protected JMenu createVisibilityMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Visibility");
        commandMenu.add(new ChangeAttributeCommand("visible", "Visibility", Boolean.TRUE));
        commandMenu.add(new ChangeAttributeCommand("invisible", "Visibility", Boolean.FALSE));
        return commandMenu;
    }

    protected JMenu createArrowMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Arrow");
        commandMenu.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0)));
        commandMenu.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1)));
        commandMenu.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2)));
        commandMenu.add(new ChangeAttributeCommand("at Both", "ArrowMode", new Integer(3)));
        return commandMenu;
    }

    protected JMenu createLineStyleMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Line Style");
        commandMenu.add(new ChangeAttributeCommand("normal", "LineStyle", ""));
        commandMenu.add(new ChangeAttributeCommand("dotted", "LineStyle", "1 2"));
        commandMenu.add(new ChangeAttributeCommand("dashed", "LineStyle", "10"));
        commandMenu.add(new ChangeAttributeCommand("medium dashed", "LineStyle", "15 10"));
        commandMenu.add(new ChangeAttributeCommand("long dashed", "LineStyle", "20"));
        commandMenu.add(new ChangeAttributeCommand("dash-dotted", "LineStyle", "7 3 1 3"));
        commandMenu.add(new QueryAttributeCommand("Line style (sequence of dash/gap lengths)", "other...", "LineStyle", String.class));
        return commandMenu;
    }

    protected JMenu createLineShapeMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Line Shape");
        commandMenu.add(new ChangeAttributeCommand("straight", "LineShape", new Integer(0)));
        commandMenu.add(this.createBSplineMenu());
        return commandMenu;
    }

    protected JMenu createLineWidthMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Line Width");
        for (int i = 1; i <= 10; ++i) {
            commandMenu.add(new SetLineWidthCommand(i + "", i));
        }
        return commandMenu;
    }

    protected JMenu createBSplineMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("B-Spline");
        commandMenu.add(new SplineAttributeCommand("standard", "standard", 0));
        commandMenu.add(this.createBSplineSegmentsMenu());
        commandMenu.add(this.createBSplineDegreeMenu());
        return commandMenu;
    }

    protected JMenu createBSplineSegmentsMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Segments");
        for (int i = 5; i < 46; i += 5) {
            commandMenu.add(new SplineAttributeCommand(Integer.toString(i), "BSplineSegments", i));
        }
        return commandMenu;
    }

    protected JMenu createBSplineDegreeMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Degree");
        for (int i = 2; i < 10; ++i) {
            commandMenu.add(new SplineAttributeCommand(Integer.toString(i), "BSplineDegree", i));
        }
        return commandMenu;
    }

    protected JMenu createArcScaleMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Round corners");
        commandMenu.add(new ChangeAttributeCommand("scale with size", "ArcScale", Boolean.TRUE));
        commandMenu.add(new ChangeAttributeCommand("fixed radius", "ArcScale", Boolean.FALSE));
        return commandMenu;
    }

    protected JMenu createFontMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Font");
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length && i < 30; ++i) {
            commandMenu.add(new ChangeAttributeCommand(stringArray[i], "FontName", stringArray[i]));
        }
        commandMenu.add(new ChooseFontCommand("Font Name", "other...", "FontName", String.class));
        return commandMenu;
    }

    protected JMenu createFontStyleMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Font Style");
        commandMenu.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0)));
        commandMenu.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2)));
        commandMenu.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1)));
        commandMenu.add(new ChangeAttributeCommand("Underlined", "FontStyle", new Integer(ExtendedFont.UNDERLINED)));
        return commandMenu;
    }

    protected JMenu createFontSizeMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Font Size");
        int[] nArray = new int[]{9, 10, 11, 12, 14, 18, 24, 36, 48, 72};
        for (int i = 0; i < nArray.length; ++i) {
            commandMenu.add(new ChangeAttributeCommand(Integer.toString(nArray[i]), "FontSize", new Integer(nArray[i])));
        }
        commandMenu.add(new QueryAttributeCommand("Font Size", "other...", "FontSize", Integer.class));
        return commandMenu;
    }

    protected JMenu createTextAlignmentMenu() {
        CommandMenu commandMenu = DrawApplication.createCommandMenu("Text Alignment");
        commandMenu.add(new ChangeAttributeCommand("Left", "TextAlignment", new Integer(0)));
        commandMenu.add(new ChangeAttributeCommand("Center", "TextAlignment", new Integer(1)));
        commandMenu.add(new ChangeAttributeCommand("Right", "TextAlignment", new Integer(2)));
        return commandMenu;
    }
}

