/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    protected Connector fOriginalTarget;
    protected Figure fTarget = null;
    protected ConnectionFigure fConnection = (ConnectionFigure)this.owner();
    protected Point fStart;

    protected ChangeConnectionHandle(Figure figure) {
        super(figure);
    }

    protected abstract Connector target();

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setPoint(int var1, int var2);

    protected Connector source() {
        if (this.target() == this.fConnection.start()) {
            return this.fConnection.end();
        }
        return this.fConnection.start();
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        this.fOriginalTarget = this.target();
        this.fStart = new Point(n, n2);
        this.disconnect();
    }

    @Override
    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector;
        Point point = new Point(n, n2);
        Figure figure = this.findConnectableFigure(n, n2, drawingView.drawing());
        if (figure != this.fTarget) {
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(false);
            }
            this.fTarget = figure;
            if (this.fTarget != null) {
                this.fTarget.connectorVisibility(true);
            }
        }
        if ((connector = this.findConnectionTarget(point.x, point.y, drawingView.drawing())) != null) {
            point = Geom.center(connector.displayBox());
        }
        this.setPoint(point.x, point.y);
    }

    @Override
    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        Connector connector = this.findConnectionTarget(n, n2, drawingView.drawing());
        if (connector == null) {
            connector = this.fOriginalTarget;
            this.noChangesMade();
        }
        this.setPoint(n, n2);
        this.connect(connector);
        this.fConnection.updateConnection();
        if (this.fTarget != null) {
            this.fTarget.connectorVisibility(false);
            this.fTarget = null;
        }
        super.invokeEnd(n, n2, n3, n4, drawingView);
    }

    private Connector findConnectionTarget(int n, int n2, Drawing drawing) {
        Figure figure = this.findConnectableFigure(n, n2, drawing);
        if (figure != null && figure.canConnect() && figure != this.fOriginalTarget && !figure.includes(this.owner()) && this.fConnection.canConnect(this.source().owner(), figure)) {
            return this.findConnector(n, n2, figure);
        }
        return null;
    }

    protected Connector findConnector(int n, int n2, Figure figure) {
        return figure.connectorAt(n, n2);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.green);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private Figure findConnectableFigure(int n, int n2, Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure.includes(this.fConnection) || !figure.canConnect() || !figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }
}

