/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.standard.QueryAttributeCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChooseColorCommand
extends QueryAttributeCommand {
    private JFrame lastParent = null;
    private JDialog dialog = null;
    private JColorChooser chooser;

    public ChooseColorCommand(String string, String string2, String string3, Class<?> clazz) {
        super(string, string2, string3, clazz);
    }

    private JDialog getDialog() {
        JFrame jFrame = DrawPlugin.getGui().getFrame();
        if (this.dialog != null) {
            if (this.lastParent == jFrame) {
                return this.dialog;
            }
            this.dialog.dispose();
        }
        this.dialog = new JDialog((Frame)jFrame, "Change " + this.displayName + ":");
        this.lastParent = jFrame;
        this.chooser = new JColorChooser();
        this.chooser.setPreviewPanel(new JPanel());
        this.dialog.getContentPane().add((Component)this.chooser, "Center");
        this.dialog.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ChooseColorCommand.this.apply(ChooseColorCommand.this.getType());
                } else if (keyEvent.getKeyCode() == 27) {
                    QueryAttributeCommand.closeDialog(ChooseColorCommand.this.dialog);
                }
            }
        });
        JButton jButton = new JButton(" Apply ");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseColorCommand.this.apply(ChooseColorCommand.this.getType());
            }
        });
        JButton jButton2 = new JButton(" Update ");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseColorCommand.this.updateFromFigure();
            }
        });
        JButton jButton3 = new JButton(" OK ");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseColorCommand.this.apply(ChooseColorCommand.this.getType());
                QueryAttributeCommand.closeDialog(ChooseColorCommand.this.dialog);
            }
        });
        JButton jButton4 = new JButton(" Cancel ");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryAttributeCommand.closeDialog(ChooseColorCommand.this.dialog);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        this.dialog.getContentPane().add((Component)jPanel, "Last");
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                QueryAttributeCommand.closeDialog(ChooseColorCommand.this.dialog);
            }
        });
        this.dialog.pack();
        return this.dialog;
    }

    @Override
    public void execute() {
        JDialog jDialog = this.getDialog();
        this.updateFromFigure();
        jDialog.setVisible(true);
        MenuManager.getInstance().getWindowsMenu().addDialog("Attributes", jDialog);
    }

    private void updateFromFigure() {
        DrawingView drawingView = this.getEditor().view();
        Object object = null;
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Object object2 = figure.getAttribute(this.fAttribute);
            if (object2 == null) continue;
            if (object != null && !object.equals(object2)) {
                object = null;
                break;
            }
            object = object2;
        }
        if (object != null && object instanceof Color) {
            this.chooser.setColor((Color)object);
        }
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    private boolean apply(Class<?> clazz) {
        Color color = null;
        if (clazz == Color.class) {
            color = this.chooser.getColor();
        }
        if (color != null) {
            new ChangeAttributeCommand("", this.fAttribute, color).execute();
        }
        return color != null;
    }
}

