/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.standard.QueryAttributeCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseFontCommand
extends QueryAttributeCommand {
    private JList fontList;
    private JList sizeList;
    private JCheckBox cbBold;
    private JCheckBox cbItalic;
    private JTextArea txtSample;
    private static final int[] sizes = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 30, 36, 48, 72};
    private SizeListModel sizeModel;
    private JFrame lastParent = null;
    private JDialog dialog = null;

    public ChooseFontCommand(String string, String string2, String string3, Class<?> clazz) {
        super(string, string2, string3, clazz);
    }

    private JDialog getDialog() {
        JFrame jFrame = DrawPlugin.getGui().getFrame();
        if (this.dialog != null) {
            if (this.lastParent == jFrame) {
                return this.dialog;
            }
            this.dialog.dispose();
        }
        this.dialog = new JDialog((Frame)jFrame, "Change " + this.displayName + ":");
        this.lastParent = jFrame;
        this.fontList = new JList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 144);
            }
        };
        this.fontList.setSelectionMode(0);
        this.sizeModel = new SizeListModel(sizes);
        this.sizeList = new JList(this.sizeModel){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(25, 144);
            }
        };
        this.sizeList.setSelectionMode(0);
        this.cbBold = new JCheckBox("Bold");
        this.cbItalic = new JCheckBox("Italic");
        this.txtSample = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(385, 80);
            }
        };
        this.txtSample.setText("This is a sample text.");
        JButton jButton = new JButton(" Apply ");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseFontCommand.this.apply(ChooseFontCommand.this.getType());
            }
        });
        JButton jButton2 = new JButton(" Update ");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseFontCommand.this.updateFromFigure();
            }
        });
        JButton jButton3 = new JButton(" OK ");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseFontCommand.this.apply(ChooseFontCommand.this.getType());
                QueryAttributeCommand.closeDialog(ChooseFontCommand.this.dialog);
            }
        });
        JButton jButton4 = new JButton(" Cancel ");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryAttributeCommand.closeDialog(ChooseFontCommand.this.dialog);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        this.setFont(null);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ChooseFontCommand.this.txtSample.setFont(ChooseFontCommand.this.getCurrentFont());
            }
        };
        this.fontList.addListSelectionListener(listSelectionListener);
        this.sizeList.addListSelectionListener(listSelectionListener);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChooseFontCommand.this.txtSample.setFont(ChooseFontCommand.this.getCurrentFont());
            }
        };
        this.cbBold.addActionListener(actionListener);
        this.cbItalic.addActionListener(actionListener);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JScrollPane(this.fontList), "Center");
        jPanel3.add((Component)new JScrollPane(this.sizeList), "East");
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        jPanel4.add(this.cbBold);
        jPanel4.add(this.cbItalic);
        jPanel2.add((Component)jPanel4, "East");
        jPanel2.add((Component)new JScrollPane(this.txtSample), "South");
        this.dialog.getContentPane().add((Component)jPanel2, "Center");
        this.dialog.getContentPane().add((Component)jPanel, "South");
        this.dialog.setSize(200, 200);
        this.dialog.setResizable(true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                QueryAttributeCommand.closeDialog(ChooseFontCommand.this.dialog);
            }
        });
        this.dialog.pack();
        return this.dialog;
    }

    private void setFont(Font font) {
        if (font == null) {
            font = this.txtSample.getFont();
        }
        this.fontList.setSelectedValue(font.getName(), true);
        this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        Integer n = font.getSize();
        this.sizeList.setSelectedValue(n, true);
        if (!n.equals(this.sizeList.getSelectedValue())) {
            this.sizeModel.addSize(n);
            this.sizeList.setSelectedValue(n, true);
        }
        this.sizeList.ensureIndexIsVisible(this.sizeList.getSelectedIndex());
        this.cbBold.setSelected(font.isBold());
        this.cbItalic.setSelected(font.isItalic());
    }

    private Font getCurrentFont() {
        String string = (String)this.fontList.getSelectedValue();
        int n = (Integer)this.sizeList.getSelectedValue();
        int n2 = 0;
        if (this.cbBold.isSelected()) {
            ++n2;
        }
        if (this.cbItalic.isSelected()) {
            n2 += 2;
        }
        return new Font(string, n2, n);
    }

    @Override
    public void execute() {
        JDialog jDialog = this.getDialog();
        this.updateFromFigure();
        jDialog.setVisible(true);
        MenuManager.getInstance().getWindowsMenu().addDialog("Attributes", jDialog);
    }

    private void updateFromFigure() {
        DrawingView drawingView = this.getEditor().view();
        Font font = null;
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements() && font == null) {
            Figure figure = figureEnumeration.nextFigure();
            Object object = figure.getAttribute("FontName");
            Object object2 = figure.getAttribute("FontStyle");
            Object object3 = figure.getAttribute("FontSize");
            if (object == null || object2 == null || object3 == null) continue;
            font = new Font((String)object, (int)((Integer)object2), (Integer)object3);
        }
        this.setFont(font);
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    private boolean apply(Class<?> clazz) {
        String string = (String)this.fontList.getSelectedValue();
        Integer n = (Integer)this.sizeList.getSelectedValue();
        int n2 = 0;
        if (this.cbBold.isSelected()) {
            ++n2;
        }
        if (this.cbItalic.isSelected()) {
            n2 += 2;
        }
        new ChangeAttributeCommand("", "FontName", string).execute();
        new ChangeAttributeCommand("", "FontSize", n).execute();
        new ChangeAttributeCommand("", "FontStyle", new Integer(n2)).execute();
        return true;
    }

    private static class SizeListModel
    implements ListModel {
        private final List<Integer> sizeList;
        private final List<ListDataListener> listeners;

        public SizeListModel(int[] nArray) {
            this.sizeList = new ArrayList<Integer>(nArray.length * 2);
            for (int n : nArray) {
                this.sizeList.add(n);
            }
            Collections.sort(this.sizeList);
            this.listeners = new ArrayList<ListDataListener>();
        }

        public Object getElementAt(int n) {
            return this.sizeList.get(n);
        }

        @Override
        public int getSize() {
            return this.sizeList.size();
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        public void addSize(Integer n) {
            assert (n != null);
            assert (this.sizeList != null);
            int n2 = Collections.binarySearch(this.sizeList, n);
            if (n2 < 0) {
                int n3 = -n2 - 1;
                this.sizeList.add(n3, n);
                ListDataEvent listDataEvent = new ListDataEvent(this, 1, n3, n3);
                for (ListDataListener listDataListener : this.listeners) {
                    listDataListener.intervalAdded(listDataEvent);
                }
            }
            assert (this.sizeList.contains(n));
        }
    }
}

