/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.ClickableDecoration;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Decoration;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureFilter;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.FilteredFigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    public static Logger logger = Logger.getLogger(CompositeFigure.class);
    private static final long serialVersionUID = 7408153435700021866L;
    protected Vector<Figure> fFigures = new Vector();
    private int compositeFigureSerializedDataVersion = 1;

    protected CompositeFigure() {
    }

    protected void figureSetChanged() {
    }

    public Figure add(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            this.fFigures.addElement(figure);
            figure.addToContainer(this);
        }
        this.figureSetChanged();
        return figure;
    }

    public void addAll(Vector<? extends Figure> vector) {
        Enumeration<? extends Figure> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
    }

    public Figure remove(Figure figure) {
        if (this.fFigures.contains(figure)) {
            figure.removeFromContainer(this);
            this.fFigures.removeElement(figure);
            figure.release();
        }
        this.figureSetChanged();
        return figure;
    }

    public void removeAll(Vector<? extends Figure> vector) {
        Enumeration<? extends Figure> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.remove(enumeration.nextElement());
        }
    }

    public void removeAll() {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.removeFromContainer(this);
            figure.release();
        }
        this.fFigures.removeAllElements();
        this.figureSetChanged();
    }

    public synchronized Figure orphan(Figure figure) {
        this.fFigures.removeElement(figure);
        this.figureSetChanged();
        return figure;
    }

    public void orphanAll(Vector<? extends Figure> vector) {
        Enumeration<? extends Figure> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.orphan(enumeration.nextElement());
        }
    }

    public synchronized void replace(Figure figure, Figure figure2) {
        int n = this.fFigures.indexOf(figure);
        if (n != -1) {
            figure2.addToContainer(this);
            figure.changed();
            this.fFigures.setElementAt(figure2, n);
        }
        this.figureSetChanged();
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, 0);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.addElement(figure);
            figure.changed();
        }
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.isVisible()) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                rectangle.grow(5, 5);
            }
            FigureEnumeration figureEnumeration = this.figures();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                Rectangle rectangle2 = figure.displayBox();
                rectangle2.grow(1, 1);
                if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
                figure.draw(graphics);
            }
        }
    }

    @Override
    public void draw(Graphics graphics, final DrawingContext drawingContext) {
        if (this.isVisible() && drawingContext.isVisible(this)) {
            final boolean bl = drawingContext.isHighlighted(this);
            DrawingContext drawingContext2 = new DrawingContext(){

                @Override
                public boolean isHighlighted(Figure figure) {
                    if (bl) {
                        return true;
                    }
                    return drawingContext.isHighlighted(figure);
                }

                @Override
                public boolean isVisible(Figure figure) {
                    return true;
                }

                @Override
                public String expandMacro(String string) {
                    return drawingContext.expandMacro(string);
                }
            };
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle != null) {
                rectangle.grow(5, 5);
            }
            FigureEnumeration figureEnumeration = this.figures();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                Rectangle rectangle2 = figure.displayBox();
                rectangle2.grow(1, 1);
                if (!drawingContext.isVisible(figure) || rectangle != null && !rectangle2.intersects(rectangle)) continue;
                figure.draw(graphics, drawingContext2);
            }
        }
    }

    public Figure figureAt(int n) {
        return this.fFigures.elementAt(n);
    }

    @Override
    public final FigureEnumeration figures() {
        return new FigureEnumerator(this.fFigures);
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public final FigureEnumeration figuresReverse() {
        return new FilteredFigureEnumerator(new ReverseFigureEnumerator(this.fFigures), new FigureFilter(){

            @Override
            public boolean isUsed(Figure figure) {
                return figure.isVisible();
            }
        });
    }

    public Figure findFigure(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle rectangle) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure.displayBox();
            rectangle2.grow(1, 1);
            if (!rectangle.intersects(rectangle2)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int n, int n2, Figure figure) {
        if (figure == null) {
            return this.findFigure(n, n2);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.containsPoint(n, n2) || figure2.includes(figure)) continue;
            return figure2;
        }
        return null;
    }

    public Figure findFigure(Rectangle rectangle, Figure figure) {
        if (figure == null) {
            return this.findFigure(rectangle);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure2.displayBox();
            rectangle2.grow(1, 1);
            if (!rectangle.intersects(rectangle2) || figure2.includes(figure)) continue;
            return figure2;
        }
        return null;
    }

    @Override
    public Figure findFigureInside(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure().findFigureInside(n, n2);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int n, int n2, Figure figure) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2;
            Figure figure3 = figureEnumeration.nextFigure();
            if (figure3 == figure || (figure2 = figure3.findFigureInside(n, n2)) == null) continue;
            return figure2;
        }
        return null;
    }

    public Decoration findDecoration(int n, int n2) {
        Decoration decoration = null;
        block0: for (Figure figure : this.fFigures) {
            AbstractFigure abstractFigure;
            if (!(figure instanceof AbstractFigure) || !(abstractFigure = (AbstractFigure)figure).isDecorated()) continue;
            for (Decoration decoration2 : abstractFigure.getDecorations()) {
                if (!(decoration2 instanceof ClickableDecoration) || !((ClickableDecoration)decoration2).containsPoint(new Point(n, n2))) continue;
                decoration = decoration2;
                continue block0;
            }
        }
        return decoration;
    }

    @Override
    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.includes(figure)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void basicMoveBy(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure;
            Figure figure2 = figure = figureEnumeration.nextFigure();
            while (figure2 != null) {
                if (figure2 instanceof ChildFigure) {
                    if ((figure2 = ((ChildFigure)figure2).parent()) == null || !this.includes(figure2)) continue;
                    break;
                }
                figure2 = null;
            }
            if (figure2 != null) continue;
            figure.moveBy(n, n2);
        }
    }

    @Override
    public void release() {
        super.release();
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.release();
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(figureChangeEvent);
        }
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(figureChangeEvent);
        }
    }

    @Override
    public void figureChanged(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fFigures.size());
        Enumeration<Figure> enumeration = this.fFigures.elements();
        while (enumeration.hasMoreElements()) {
            storableOutput.writeStorable(enumeration.nextElement());
        }
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        this.fFigures = new Vector(n);
        for (int i = 0; i < n; ++i) {
            try {
                this.add((Figure)storableInput.readStorable());
                continue;
            }
            catch (IOException iOException) {
                logger.error((Object)("Figure expected!" + iOException));
                logger.debug((Object)"Figure expected!", (Throwable)iOException);
                break;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.addToContainer(this);
        }
    }

    @Override
    public boolean inspect(DrawingView drawingView, boolean bl) {
        Point point = drawingView.lastClick();
        Figure figure = this.findFigure(point.x, point.y);
        if (figure != null && figure.inspect(drawingView, bl)) {
            return true;
        }
        return super.inspect(drawingView, bl);
    }
}

