/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureTransferCommand;
import CH.ifa.draw.util.Clipboard;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class PasteCommand
extends FigureTransferCommand {
    public PasteCommand(String string) {
        super(string);
    }

    @Override
    public boolean executeUndoable() {
        DrawingView drawingView = this.getEditor().view();
        Point point = drawingView.lastClick();
        FigureSelection figureSelection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (figureSelection != null) {
            Vector<Figure> vector = figureSelection.getData("CH.ifa.draw.Figures");
            if (vector.size() == 0) {
                return false;
            }
            Rectangle rectangle = this.bounds(vector.elements());
            drawingView.clearSelection();
            this.insertFigures(vector, point.x - rectangle.x, point.y - rectangle.y);
            drawingView.checkDamage();
            return true;
        }
        return false;
    }

    Rectangle bounds(Enumeration<Figure> enumeration) {
        Rectangle rectangle = enumeration.nextElement().displayBox();
        while (enumeration.hasMoreElements()) {
            rectangle.add(enumeration.nextElement().displayBox());
        }
        return rectangle;
    }
}

