/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class QueryAttributeCommand
extends Command {
    String fAttribute;
    TextField input;
    private Class<?> type;
    String displayName;
    static final String WINDOWS_CATEGORY_ATTRIBUTES = "Attributes";

    public QueryAttributeCommand(String string, String string2, String string3, Class<?> clazz) {
        super(string2);
        this.fAttribute = string3;
        this.displayName = string;
        this.type = clazz;
    }

    private Dialog getDialog() {
        JFrame jFrame = DrawPlugin.getGui().getFrame();
        final Dialog dialog = new Dialog((Frame)jFrame, "Change " + this.displayName + ":");
        this.input = new TextField();
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    QueryAttributeCommand.this.apply(QueryAttributeCommand.this.type);
                } else if (keyEvent.getKeyCode() == 27) {
                    QueryAttributeCommand.closeDialog(dialog);
                }
            }
        });
        dialog.add((Component)this.input, "Center");
        Button button = new Button(" Apply ");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryAttributeCommand.this.apply(QueryAttributeCommand.this.type);
            }
        });
        Button button2 = new Button(" Update ");
        button2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryAttributeCommand.this.execute();
            }
        });
        Button button3 = new Button(" OK ");
        button3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryAttributeCommand.this.apply(QueryAttributeCommand.this.type);
                QueryAttributeCommand.closeDialog(dialog);
            }
        });
        Button button4 = new Button(" Cancel ");
        button4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryAttributeCommand.this.resetFocus();
                QueryAttributeCommand.closeDialog(dialog);
            }
        });
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(button);
        panel.add(button2);
        panel.add(button3);
        panel.add(button4);
        dialog.add((Component)panel, "South");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                QueryAttributeCommand.closeDialog(dialog);
            }
        });
        dialog.pack();
        return dialog;
    }

    static void closeDialog(Dialog dialog) {
        MenuManager.getInstance().getWindowsMenu().removeDialog(dialog);
        dialog.setVisible(false);
    }

    protected DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }

    @Override
    public void execute() {
        Object object;
        DrawingView drawingView = this.getEditor().view();
        Dialog dialog = this.getDialog();
        Object object2 = null;
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            object = figureEnumeration.nextFigure();
            Object object3 = object.getAttribute(this.fAttribute);
            if (object3 == null) continue;
            if (object2 != null && !object2.equals(object3)) {
                object2 = null;
                break;
            }
            object2 = object3;
        }
        object = "";
        if (object2 != null) {
            object = object2 instanceof Color ? "0x" + Integer.toHexString(((Color)object2).getRGB()).substring(2) : object2.toString();
        }
        this.input.setText((String)object);
        this.resetFocus();
        dialog.setVisible(true);
        MenuManager.getInstance().getWindowsMenu().addDialog(WINDOWS_CATEGORY_ATTRIBUTES, dialog);
    }

    private void resetFocus() {
        this.input.requestFocus();
        this.input.setSelectionStart(0);
        this.input.setSelectionEnd(this.input.getText().length());
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    private boolean apply(Class<?> clazz) {
        String string = this.input.getText();
        Object object = null;
        try {
            if (clazz == Integer.class) {
                object = Integer.valueOf(string);
            } else if (clazz == String.class) {
                object = string;
            } else if (clazz == Color.class) {
                object = Color.decode(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (object != null) {
            new ChangeAttributeCommand("", this.fAttribute, object).execute();
        }
        this.resetFocus();
        return object != null;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getAttributeName() {
        return this.fAttribute;
    }
}

