/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.FigureException;
import CH.ifa.draw.standard.SubstringMatcher;
import CH.ifa.draw.util.GUIProperties;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SearchReplaceFrame {
    public static final int SEARCHMODE = 0;
    public static final int SEARCHREPLACEMODE = 1;
    private Enumeration<Drawing> drawings;
    private FigureEnumeration figures;
    private Drawing drawing;
    private JFrame frame;
    private boolean stringMatcherValid = false;
    private SubstringMatcher substringMatcher;
    private int mode;
    private boolean cancelSearchInAllDrawings = true;
    private boolean searchAll = true;
    private boolean ignoreCase = true;
    private boolean newSearch = true;

    public SearchReplaceFrame(int n) {
        this.mode = n;
        String string = this.mode == 0 ? "Search" : "Search & Replace";
        this.frame = new JFrame(string);
        if (!GUIProperties.avoidFrameReshape()) {
            this.frame.setSize(600, 200);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.frame.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel("Search for:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.frame.getContentPane().add(jLabel);
        gridBagConstraints.gridwidth = 0;
        final JTextField jTextField = new JTextField("", 30);
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SearchReplaceFrame.this.reset();
            }
        });
        this.frame.getContentPane().add(jTextField);
        final JTextField jTextField2 = new JTextField("", 30);
        if (this.mode == 1) {
            gridBagConstraints.gridwidth = 1;
            jLabel = new JLabel("Replace with:");
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.frame.getContentPane().add(jLabel);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jTextField2, gridBagConstraints);
            jTextField2.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    SearchReplaceFrame.this.stringMatcherValid = false;
                }
            });
            this.frame.getContentPane().add(jTextField2);
        }
        JCheckBox jCheckBox = new JCheckBox("Search all drawings", this.searchAll);
        this.frame.getContentPane().add(jCheckBox);
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchReplaceFrame.this.searchAll = !SearchReplaceFrame.this.searchAll;
                SearchReplaceFrame.this.reset();
            }
        });
        gridBagConstraints.gridwidth = 13;
        gridBagLayout.setConstraints(jCheckBox, gridBagConstraints);
        JCheckBox jCheckBox2 = new JCheckBox("Ignore case", this.ignoreCase);
        this.frame.getContentPane().add(jCheckBox2);
        jCheckBox2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchReplaceFrame.this.ignoreCase = !SearchReplaceFrame.this.ignoreCase;
            }
        });
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jCheckBox2, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        String string2 = this.mode == 0 ? "Search" : "Search & Replace";
        JButton jButton = new JButton(string2);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.frame.getContentPane().add(jButton);
        this.frame.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("".equals(jTextField.getText())) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (!SearchReplaceFrame.this.stringMatcherValid) {
                    if (SearchReplaceFrame.this.mode == 0) {
                        SearchReplaceFrame.this.substringMatcher = new SubstringMatcher(jTextField.getText(), null);
                    } else {
                        SearchReplaceFrame.this.substringMatcher = new SubstringMatcher(jTextField.getText(), jTextField2.getText());
                    }
                    SearchReplaceFrame.this.stringMatcherValid = true;
                }
                SearchReplaceFrame.this.searchInDrawings();
            }
        });
        gridBagConstraints.gridwidth = 0;
        JButton jButton2 = new JButton("Cancel");
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        this.frame.getContentPane().add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchReplaceFrame.this.cancel();
            }
        });
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SearchReplaceFrame.this.frame.setVisible(false);
                MenuManager.getInstance().getWindowsMenu().removeFrame(SearchReplaceFrame.this.frame);
            }
        });
        this.frame.pack();
        this.reset();
    }

    private void handleFoundFigure(TextFigure textFigure) {
        if (this.mode == 1) {
            String string = textFigure.getText();
            String string2 = "";
            int n = 0;
            while (this.substringMatcher.matches(string, n, this.ignoreCase)) {
                string2 = this.substringMatcher.replacement(string, n);
                int n2 = this.substringMatcher.indexOf(string, n);
                int n3 = JOptionPane.showConfirmDialog(this.frame, "Replace:\n" + string + "\nwith:\n" + string2, "Confirm Replacement", 1);
                switch (n3) {
                    case 2: {
                        this.reset();
                        this.cancelSearchInAllDrawings = true;
                        this.setVisible(false);
                        return;
                    }
                    case 0: {
                        DrawApplication drawApplication = DrawPlugin.getGui();
                        drawApplication.prepareUndoSnapshot();
                        textFigure.setText(string2);
                        string = string2;
                        n = n2 + this.substringMatcher.getReplaceString().length();
                        drawApplication.commitUndoSnapshot();
                        drawApplication.view().checkDamage();
                        break;
                    }
                    case 1: {
                        n = n2 + this.substringMatcher.getSearchString().length();
                    }
                }
            }
        }
    }

    private void searchInDrawings() {
        TextFigure textFigure = null;
        this.cancelSearchInAllDrawings = false;
        while (!this.cancelSearchInAllDrawings && (this.drawings.hasMoreElements() || this.drawing != null)) {
            if (this.newSearch) {
                this.newSearch = false;
                if (this.drawings.hasMoreElements()) {
                    this.drawing = this.drawings.nextElement();
                    this.figures = this.drawing.figures();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            if ((textFigure = this.searchInOneDrawing()) != null) {
                FigureException figureException;
                DrawApplication drawApplication = DrawPlugin.getGui();
                if (this.mode == 0) {
                    figureException = new FigureException("Heureka", 1, this.substringMatcher.getLastposition() + 1, this.drawing, textFigure);
                    drawApplication.selectOffendingElements(figureException);
                    return;
                }
                figureException = new FigureException("Heureka", "", this.drawing, textFigure);
                drawApplication.selectOffendingElements(figureException);
                this.handleFoundFigure(textFigure);
                continue;
            }
            this.newSearch = true;
            this.drawing = null;
        }
        if (!this.cancelSearchInAllDrawings && !this.figures.hasMoreElements() & textFigure == null) {
            Toolkit.getDefaultToolkit().beep();
            this.reset();
        }
    }

    private TextFigure searchInOneDrawing() {
        while (this.figures.hasMoreElements()) {
            TextFigure textFigure;
            String string;
            Figure figure = this.figures.nextFigure();
            if (!(figure instanceof TextFigure) || !this.substringMatcher.matches(string = (textFigure = (TextFigure)figure).getText(), this.ignoreCase)) continue;
            return textFigure;
        }
        return null;
    }

    protected void reset() {
        DrawApplication drawApplication = DrawPlugin.getGui();
        if (drawApplication != null) {
            drawApplication.tool().deactivate();
            this.drawing = drawApplication.drawing();
            if (this.searchAll) {
                this.drawings = drawApplication.drawings();
            } else {
                Vector<Drawing> vector = new Vector<Drawing>();
                vector.add(this.drawing);
                this.drawings = vector.elements();
            }
            this.figures = this.drawing.figures();
            this.newSearch = true;
            this.stringMatcherValid = false;
        }
    }

    private void cancel() {
        this.setVisible(false);
        DrawPlugin.getGui().toolDone();
    }

    protected void setVisible(boolean bl) {
        this.frame.setVisible(bl);
        if (bl) {
            MenuManager.getInstance().getWindowsMenu().addFrame("Tools", this.frame);
        } else {
            MenuManager.getInstance().getWindowsMenu().removeFrame(this.frame);
        }
    }
}

