/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.UndoableCommand;
import CH.ifa.draw.standard.GridConstrainer;
import java.awt.Point;

public class SnapToGridCommand
extends UndoableCommand {
    private Point fGrid;

    public SnapToGridCommand(String string, Point point) {
        super(string);
        this.fGrid = new Point(point.x, point.y);
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return this.getEditor().view().selectionCount() > 0;
    }

    @Override
    public boolean executeUndoable() {
        DrawingView drawingView = this.getEditor().view();
        PointConstrainer pointConstrainer = drawingView.getConstrainer();
        if (pointConstrainer == null) {
            System.out.println("No active grid - using default grid.");
            pointConstrainer = new GridConstrainer(this.fGrid.x, this.fGrid.y);
        }
        FigureEnumeration figureEnumeration = drawingView.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Point point = figure.center();
            Point point2 = pointConstrainer.constrainPoint(figure.center());
            figure.moveBy(point2.x - point.x, point2.y - point.y);
        }
        drawingView.checkDamage();
        return true;
    }
}

