/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.framework.FigureWithDependencies;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.ContextGraphics;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class StandardDrawingView
extends JPanel
implements DrawingView,
FigureChangeListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = -3878153366174603336L;
    private static Logger logger = Logger.getLogger(StandardDrawingView.class);
    private transient DrawingEditor fEditor;
    private Drawing fDrawing;
    private transient Rectangle fDamage = null;
    private transient Vector<Figure> fSelection;
    private transient Vector<Handle> fSelectionHandles;
    private transient Object selectionHandlesLock = new Object();
    private Dimension fViewSize;
    private Point fLastClick;
    private Vector<Painter> fBackgrounds = null;
    private Vector<Painter> fForegrounds = null;
    private Painter fUpdateStrategy;
    private PointConstrainer fConstrainer;
    private int drawingViewSerializedDataVersion = 1;
    private transient Object repaintLock = new Object();

    public StandardDrawingView(DrawingEditor drawingEditor, int n, int n2) {
        this.fEditor = drawingEditor;
        this.fViewSize = new Dimension(n, n2);
        this.fLastClick = new Point(0, 0);
        this.fConstrainer = null;
        this.fSelection = new Vector();
        if (GUIProperties.specialUpdate()) {
            this.setDisplayUpdate(new SimpleUpdateStrategy());
        } else {
            this.setDisplayUpdate(new BufferedUpdateStrategy());
        }
        this.setBackground(Color.lightGray);
        this.setOpaque(true);
        this.setLayout(null);
    }

    @Override
    public void setEditor(DrawingEditor drawingEditor) {
        this.fEditor = drawingEditor;
    }

    @Override
    public Tool tool() {
        return this.fEditor.tool();
    }

    @Override
    public Drawing drawing() {
        return this.fDrawing;
    }

    @Override
    public void setDrawing(Drawing drawing) {
        if (this.fDrawing != null) {
            this.clearSelection();
            this.fDrawing.removeDrawingChangeListener(this);
        }
        this.fDrawing = drawing;
        this.fDrawing.addDrawingChangeListener(this);
        this.checkMinimumSize(null);
        this.repaint();
    }

    @Override
    public DrawingEditor editor() {
        return this.fEditor;
    }

    @Override
    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    @Override
    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    @Override
    public void addAll(Vector<Figure> vector) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            this.add(figureEnumerator.nextFigure());
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.fViewSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void setDisplayUpdate(Painter painter) {
        this.fUpdateStrategy = painter;
    }

    @Override
    public Vector<Figure> selection() {
        return (Vector)this.fSelection.clone();
    }

    @Override
    public FigureEnumeration selectionElements() {
        return new FigureEnumerator((Vector)this.fSelection.clone());
    }

    @Override
    public Vector<Figure> inZOrder(Vector<Figure> vector) {
        Vector<Figure> vector2 = new Vector<Figure>(vector.size());
        FigureEnumeration figureEnumeration = this.drawing().figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!vector.contains(figure)) continue;
            vector2.addElement(figure);
        }
        return vector2;
    }

    @Override
    public Vector<Figure> selectionZOrdered() {
        return this.inZOrder(this.fSelection);
    }

    @Override
    public int selectionCount() {
        return this.fSelection.size();
    }

    @Override
    public void addToSelection(Figure figure) {
        if (this.addToSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    protected boolean addToSelectionInternal(Figure figure) {
        if (!this.fSelection.contains(figure) && figure.isSelectable()) {
            this.fSelection.addElement(figure);
            figure.addFigureChangeListener(this);
            this.selectionInvalidateHandles();
            figure.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void addToSelectionAll(Vector<Figure> vector) {
        this.addToSelectionAll(new FigureEnumerator(vector));
    }

    @Override
    public void addToSelectionAll(FigureEnumeration figureEnumeration) {
        boolean bl = false;
        while (figureEnumeration.hasMoreElements()) {
            bl |= this.addToSelectionInternal(figureEnumeration.nextFigure());
        }
        if (bl) {
            this.selectionChanged();
        }
    }

    @Override
    public void removeFromSelection(Figure figure) {
        if (this.removeFromSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    protected boolean removeFromSelectionInternal(Figure figure) {
        if (this.fSelection.contains(figure)) {
            this.fSelection.removeElement(figure);
            figure.removeFigureChangeListener(this);
            this.selectionInvalidateHandles();
            figure.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void removeFromSelectionAll(Vector<Figure> vector) {
        this.removeFromSelectionAll(new FigureEnumerator(vector));
    }

    @Override
    public void removeFromSelectionAll(FigureEnumeration figureEnumeration) {
        boolean bl = false;
        while (figureEnumeration.hasMoreElements()) {
            bl |= this.removeFromSelectionInternal(figureEnumeration.nextFigure());
        }
        if (bl) {
            this.selectionChanged();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.toggleSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    public boolean toggleSelectionInternal(Figure figure) {
        if (this.fSelection.contains(figure)) {
            return this.removeFromSelectionInternal(figure);
        }
        return this.addToSelectionInternal(figure);
    }

    @Override
    public void toggleSelectionAll(Vector<Figure> vector) {
        this.toggleSelectionAll(new FigureEnumerator(vector));
    }

    @Override
    public void toggleSelectionAll(FigureEnumeration figureEnumeration) {
        boolean bl = false;
        while (figureEnumeration.hasMoreElements()) {
            bl |= this.toggleSelectionInternal(figureEnumeration.nextFigure());
        }
        if (bl) {
            this.selectionChanged();
        }
    }

    @Override
    public void clearSelection() {
        FigureEnumeration figureEnumeration = this.selectionElements();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.removeFigureChangeListener(this);
            figure.invalidate();
        }
        this.fSelection = new Vector();
        this.selectionInvalidateHandles();
        this.selectionChanged();
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureChanged(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
        this.removeFromSelection(figureChangeEvent.getFigure());
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionInvalidateHandles() {
        Object object = this.selectionHandlesLock;
        synchronized (object) {
            this.fSelectionHandles = null;
        }
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent figureChangeEvent) {
        this.selectionInvalidateHandles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<Handle> selectionHandles() {
        Object object = this.selectionHandlesLock;
        synchronized (object) {
            if (this.fSelectionHandles == null) {
                this.fSelectionHandles = new Vector();
                FigureEnumeration figureEnumeration = this.selectionElements();
                while (figureEnumeration.hasMoreElements()) {
                    Figure figure = figureEnumeration.nextFigure();
                    Enumeration<Handle> enumeration = figure.handles().elements();
                    while (enumeration.hasMoreElements()) {
                        this.fSelectionHandles.addElement(enumeration.nextElement());
                    }
                }
            }
            return this.fSelectionHandles.elements();
        }
    }

    private static void tryAdd(Vector<Figure> vector, Figure figure) {
        if (figure != null && !vector.contains(figure)) {
            vector.addElement(figure);
        }
    }

    public static Vector<Figure> expandFigureVector(Vector<Figure> vector) {
        Vector vector2 = (Vector)vector.clone();
        for (int i = 0; i < vector2.size(); ++i) {
            Figure figure = (Figure)vector2.elementAt(i);
            if (!(figure instanceof FigureWithDependencies)) continue;
            FigureWithDependencies figureWithDependencies = (FigureWithDependencies)figure;
            FigureEnumeration figureEnumeration = figureWithDependencies.getFiguresWithDependencies();
            while (figureEnumeration.hasMoreElements()) {
                StandardDrawingView.tryAdd(vector2, figureEnumeration.nextFigure());
            }
        }
        return vector2;
    }

    @Override
    public FigureSelection getFigureSelection() {
        return new FigureSelection(this.inZOrder(StandardDrawingView.expandFigureVector(this.fSelection)));
    }

    @Override
    public Handle findHandle(int n, int n2) {
        Enumeration<Handle> enumeration = this.selectionHandles();
        while (enumeration.hasMoreElements()) {
            Handle handle = enumeration.nextElement();
            if (!handle.containsPoint(n, n2)) continue;
            return handle;
        }
        return null;
    }

    protected void selectionChanged() {
        this.fEditor.selectionChanged(this);
    }

    @Override
    public Point lastClick() {
        return this.fLastClick;
    }

    @Override
    public void setConstrainer(PointConstrainer pointConstrainer) {
        this.fConstrainer = pointConstrainer;
    }

    @Override
    public PointConstrainer getConstrainer() {
        return this.fConstrainer;
    }

    protected Point constrainPoint(Point point) {
        Dimension dimension = this.getSize();
        point.x = Geom.range(1, dimension.width, point.x);
        point.y = Geom.range(1, dimension.height, point.y);
        if (this.fConstrainer != null) {
            return this.fConstrainer.constrainPoint(point);
        }
        return point;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiers() & 0xC) != 0;
        if (this.tool() != this.editor().defaultTool() && bl && mouseEvent.getClickCount() == 1) {
            this.editor().setStickyTools(false);
            this.editor().toolDone();
        } else {
            this.requestFocus();
            Point point = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            this.fLastClick = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.tool().mouseDown(mouseEvent, point.x, point.y);
            this.checkDamage();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.tool().mouseDrag(mouseEvent, point.x, point.y);
        this.checkDamage();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.tool().mouseMove(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = this.constrainPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.tool().mouseUp(mouseEvent, point.x, point.y);
        this.checkDamage();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 8 || n == 127) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Delete pressed"));
            }
            DeleteCommand deleteCommand = new DeleteCommand("Delete");
            ((Command)deleteCommand).execute();
        } else if (n == 40 || n == 38 || n == 39 || n == 37) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Arrow pressed"));
            }
            this.handleCursorKey(n, keyEvent.getModifiers());
            if (this.fSelection.size() > 0) {
                keyEvent.consume();
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Pushing KeyEvent to tool e: " + n + " , " + keyEvent.getKeyChar()));
            }
            this.tool().keyDown(keyEvent, n);
        }
        this.checkDamage();
    }

    protected void handleCursorKey(int n) {
        this.handleCursorKey(n, 0);
    }

    protected void handleCursorKey(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        if (this.fConstrainer != null) {
            n5 = this.fConstrainer.getStepX();
            n6 = this.fConstrainer.getStepY();
        }
        if ((n2 & 1) != 0) {
            n5 *= 10;
            n6 *= 10;
        }
        switch (n) {
            case 40: {
                n4 = n6;
                break;
            }
            case 38: {
                n4 = -n6;
                break;
            }
            case 39: {
                n3 = n5;
                break;
            }
            case 37: {
                n3 = -n5;
            }
        }
        this.moveSelection(n3, n4);
    }

    public static void moveFigures(Vector<Figure> vector, int n, int n2) {
        FigureEnumerator figureEnumerator = new FigureEnumerator(vector);
        while (figureEnumerator.hasMoreElements()) {
            Figure figure;
            Figure figure2 = figure = figureEnumerator.nextFigure();
            while (figure2 != null) {
                if (figure2 instanceof ChildFigure) {
                    if ((figure2 = ((ChildFigure)figure2).parent()) == null || !vector.contains(figure2)) continue;
                    break;
                }
                figure2 = null;
            }
            if (figure2 != null) continue;
            figure.moveBy(n, n2);
        }
    }

    @Override
    public void moveSelection(int n, int n2) {
        StandardDrawingView.moveFigures(this.fSelection, n, n2);
        this.checkDamage();
    }

    @Override
    public synchronized void checkDamage() {
        Enumeration<DrawingChangeListener> enumeration = this.drawing().drawingChangeListeners();
        while (enumeration.hasMoreElements()) {
            DrawingChangeListener drawingChangeListener = enumeration.nextElement();
            if (!(drawingChangeListener instanceof DrawingView)) continue;
            ((DrawingView)drawingChangeListener).repairDamage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairDamage() {
        Object object = this.repaintLock;
        synchronized (object) {
            if (this.fDamage != null) {
                if (this.fDamage.x + this.fDamage.width > this.fViewSize.width || this.fDamage.y + this.fDamage.height > this.fViewSize.height) {
                    this.checkMinimumSize(this.fDamage);
                }
                this.repaint(0L, this.fDamage.x, this.fDamage.y, this.fDamage.width, this.fDamage.height);
                this.fDamage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        Object object = this.repaintLock;
        synchronized (object) {
            Rectangle rectangle = drawingChangeEvent.getInvalidatedRectangle();
            if (rectangle != null) {
                if (this.fDamage == null) {
                    this.fDamage = rectangle;
                } else {
                    this.fDamage.add(rectangle);
                }
            }
        }
    }

    @Override
    public void drawingRequestUpdate(DrawingChangeEvent drawingChangeEvent) {
        this.repairDamage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.fUpdateStrategy.draw(graphics2D, this);
        Object object = this.repaintLock;
        synchronized (object) {
            if (this.fDamage != null) {
                this.repaint(0L, this.fDamage.x, this.fDamage.y, this.fDamage.width, this.fDamage.height);
                this.fDamage = null;
            }
        }
    }

    @Override
    public void drawAll(Graphics graphics) {
        boolean bl = graphics instanceof PrintGraphics;
        this.drawBackground(graphics);
        if (this.fBackgrounds != null && !bl) {
            this.drawPainters(graphics, this.fBackgrounds);
        }
        ContextGraphics contextGraphics = new ContextGraphics((Graphics2D)graphics, this.getBackground());
        this.drawDrawing(contextGraphics);
        if (this.fForegrounds != null && !bl) {
            this.drawPainters(graphics, this.fForegrounds);
        }
        if (!bl) {
            this.drawHandles(graphics);
        }
        if (this.fDrawing == this.fEditor.drawing()) {
            this.tool().draw(graphics);
        }
    }

    @Override
    public void drawHandles(Graphics graphics) {
        Enumeration<Handle> enumeration = this.selectionHandles();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().draw(graphics);
        }
    }

    @Override
    public void drawDrawing(Graphics graphics) {
        this.fDrawing.draw(graphics);
    }

    @Override
    public void drawBackground(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = this.getBounds();
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
    }

    private void drawPainters(Graphics graphics, Vector<Painter> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            vector.elementAt(i).draw(graphics, this);
        }
    }

    public void addBackground(Painter painter) {
        if (this.fBackgrounds == null) {
            this.fBackgrounds = new Vector(3);
        }
        this.fBackgrounds.addElement(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this.fBackgrounds != null) {
            this.fBackgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this.fForegrounds != null) {
            this.fForegrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this.fForegrounds == null) {
            this.fForegrounds = new Vector(3);
        }
        this.fForegrounds.addElement(painter);
        this.repaint();
    }

    @Override
    public void freezeView() {
    }

    @Override
    public void unfreezeView() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fSelection = new Vector();
        this.selectionHandlesLock = new Object();
        this.repaintLock = new Object();
        if (this.fDrawing != null) {
            this.fDrawing.addDrawingChangeListener(this);
        }
    }

    private void checkMinimumSize(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = this.fDrawing.getBounds();
        }
        Dimension dimension = new Dimension(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        if (this.fViewSize.height < dimension.height) {
            this.fViewSize.height = dimension.height + 10;
        }
        if (this.fViewSize.width < dimension.width) {
            this.fViewSize.width = dimension.width + 10;
        }
        Dimension dimension2 = this.getSize();
        boolean bl = false;
        if (dimension2.width < this.fViewSize.width) {
            dimension2.width = this.fViewSize.width;
            bl = true;
        }
        if (dimension2.height < this.fViewSize.height) {
            dimension2.height = this.fViewSize.height;
            bl = true;
        }
        if (bl) {
            this.setSize(dimension2.width, dimension2.height);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void showElement(Figure figure) {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
        }
        if (container != null) {
            JScrollPane jScrollPane = (JScrollPane)container;
            Point point = figure.center();
            int n = point.x - jScrollPane.getWidth() / 2;
            int n2 = point.y - jScrollPane.getHeight() / 2;
            int n3 = jScrollPane.getViewport().getWidth();
            int n4 = jScrollPane.getViewport().getHeight();
            int n5 = jScrollPane.getViewport().getView().getWidth();
            int n6 = jScrollPane.getViewport().getView().getHeight();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n + n3 > n5) {
                n = n5 - n3;
            }
            if (n2 + n4 > n6) {
                n2 = n6 - n4;
            }
            jScrollPane.getViewport().setViewPosition(new Point(n, n2));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        if (graphics instanceof Graphics2D) {
            double d;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double d2 = pageFormat.getImageableHeight() / (double)this.getHeight();
            double d3 = pageFormat.getImageableWidth() / (double)this.getWidth();
            double d4 = d = d2 > d3 ? d3 : d2;
            if (d < 1.0) {
                graphics2D.scale(d, d);
            }
            this.drawAll(graphics);
            return 0;
        }
        return 1;
    }
}

