/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.PointConstrainer;
import CH.ifa.draw.standard.GridConstrainer;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import java.awt.Point;

public class ToggleGridCommand
extends Command {
    private Point fGrid;

    protected DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }

    public ToggleGridCommand(String string, Point point) {
        super(string);
        this.fGrid = new Point(point.x, point.y);
    }

    @Override
    public boolean isExecutable() {
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        return super.isExecutable();
    }

    @Override
    public void execute() {
        DrawingView drawingView = this.getEditor().view();
        PointConstrainer pointConstrainer = drawingView.getConstrainer();
        if (pointConstrainer != null) {
            drawingView.setConstrainer(null);
        } else {
            drawingView.setConstrainer(new GridConstrainer(this.fGrid.x, this.fGrid.y));
        }
    }
}

