/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.GUIProperties;
import CH.ifa.draw.util.PaletteListener;
import de.renew.plugin.PluginProperties;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class ToolButton
implements ActionListener,
MouseListener,
KeyListener {
    private static final String PROP_PRE = "de.renew.keymap.";
    public static Logger logger = Logger.getLogger(ToolButton.class);
    private String fName;
    private Tool fTool;
    private JToggleButton fButton;
    private PaletteListener fListener;
    private char keyChar;

    public ToolButton(PaletteListener paletteListener, String string, String string2, Tool tool) {
        ImageIcon[] imageIconArray = ToolButton.createIconsByGuess(string);
        this.createButton(paletteListener, imageIconArray[0], imageIconArray[1], string2, tool);
        this.associateKey(string2.replaceAll(" ", "_"));
    }

    public ToolButton(PaletteListener paletteListener, Icon icon, Icon icon2, String string, Tool tool) {
        this.createButton(paletteListener, icon, icon2, string, tool);
        this.associateKey(string.replaceAll(" ", "_"));
    }

    private void associateKey(String string) {
        String string2;
        PluginProperties pluginProperties;
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        if (drawPlugin != null && (pluginProperties = drawPlugin.getProperties()).getBoolProperty("de.renew.keymap.use-mapping") && (string2 = pluginProperties.getProperty(PROP_PRE + string)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(ToolButton.class.getName() + ": found key mapping entry: " + string2));
            }
            if (string2.trim().length() == 1) {
                DrawPlugin.getGui().getFrame().addKeyListener(this);
                this.keyChar = string2.trim().charAt(0);
            }
        }
    }

    private void createButton(PaletteListener paletteListener, Icon icon, Icon icon2, String string, Tool tool) {
        this.fButton = new JToggleButton();
        this.fButton.setIcon(icon);
        this.fButton.setToolTipText(string);
        if (icon2 != null) {
            this.fButton.setSelectedIcon(icon2);
        }
        this.fButton.addMouseListener(this);
        this.fButton.addActionListener(this);
        this.fButton.setToolTipText(this.fName);
        if (GUIProperties.customToolBorders()) {
            this.fButton.setBorderPainted(true);
            this.fButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
        this.fTool = tool;
        this.fName = string;
        this.fListener = paletteListener;
    }

    public Tool tool() {
        return this.fTool;
    }

    public void setTool(Tool tool) {
        this.fTool = tool;
    }

    public String name() {
        return this.fName;
    }

    public String getHotkey() {
        if (Character.isLetterOrDigit(this.keyChar) || this.keyChar == '.') {
            return " (" + this.keyChar + ")";
        }
        return "";
    }

    public Object attributeValue() {
        return this.tool();
    }

    public AbstractButton button() {
        return this.fButton;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = mouseEvent.getClickCount() > 1;
        this.fListener.paletteUserSelected(this, bl);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.fListener.paletteUserOver(this, true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fListener.paletteUserOver(this, false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        this.fListener.paletteUserSelected(this, false);
    }

    private static ImageIcon[] createIconsByGuess(String string) {
        ImageIcon imageIcon;
        ImageIcon[] imageIconArray = new ImageIcon[2];
        try {
            imageIcon = ToolButton.createIcon(string + ".gif");
        }
        catch (Exception exception) {
            logger.error((Object)("Guess for " + string + ".gif failed with " + exception));
            imageIcon = null;
        }
        if (imageIcon != null) {
            imageIconArray[0] = imageIcon;
            imageIconArray[1] = null;
        } else {
            imageIconArray[0] = ToolButton.createIcon(string + "1.gif");
            imageIconArray[1] = ToolButton.createIcon(string + "2.gif");
        }
        return imageIconArray;
    }

    private static ImageIcon createIcon(String string) {
        URL uRL = ToolButton.class.getResource(string);
        if (uRL == null) {
            File file = new File(string);
            if (!file.isFile()) {
                return null;
            }
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return new ImageIcon(uRL);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isMetaDown())) {
            if (keyEvent.getKeyChar() == this.keyChar) {
                this.fListener.paletteUserSelected(this, false);
            } else if (keyEvent.getKeyChar() == Character.toUpperCase(this.keyChar)) {
                this.fListener.paletteUserSelected(this, true);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

