/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.util.Animatable;

public class Animator
implements Runnable {
    private static final int MAX_DELAY = 62;
    private static final int MIN_DELAY = 15;
    private DrawingView fView;
    private Animatable fAnimatable;
    private boolean fIsRunning;

    public Animator(Animatable animatable, DrawingView drawingView) {
        this.fView = drawingView;
        this.fAnimatable = animatable;
    }

    public void end() {
        this.fAnimatable.animationStop();
        this.fIsRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.fIsRunning = true;
        this.fAnimatable.animationStart();
        while (this.fIsRunning) {
            long l = System.currentTimeMillis();
            this.fView.freezeView();
            try {
                this.fAnimatable.animationStep();
                this.fView.checkDamage();
            }
            finally {
                this.fView.unfreezeView();
            }
            try {
                Thread.sleep(Math.max(15L, (l += 62L) - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }
}

