/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class GUIProperties {
    public static Logger logger = Logger.getLogger(GUIProperties.class);
    private static Properties _properties = new Properties();
    private static Map<String, Boolean> lastBoolResults = new HashMap<String, Boolean>();

    private GUIProperties() {
    }

    public static void setProperties(Properties properties) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("setting GUI properties:" + properties), new Throwable("StackTrace"));
        }
        _properties = properties;
    }

    protected static boolean returnBool(String string, String string2) {
        String string3 = "de.renew." + string;
        String string4 = _properties.getProperty(string3);
        if (string4 == null && (string4 = System.getProperty(string3)) != null) {
            _properties.setProperty(string, string4);
        }
        if (string4 == null) {
            string4 = "false";
            _properties.setProperty(string, string4);
        } else if ("".equals(string4)) {
            string4 = "true";
            _properties.setProperty(string, string4);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: " + string3 + "=" + string4));
        }
        Boolean bl = Boolean.valueOf(string4);
        GUIProperties.printOptionalSetMessage(string3, bl, string2);
        return bl;
    }

    protected static void printOptionalSetMessage(String string, Boolean bl, String string2) {
        Boolean bl2 = lastBoolResults.get(string);
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        lastBoolResults.put(string, bl);
        if (!bl2.booleanValue() && bl.booleanValue() && string2 != null) {
            logger.debug((Object)(string2 + " activated."));
        } else if (bl2.booleanValue() && !bl.booleanValue() && string2 != null) {
            logger.debug((Object)(string2 + " deactivated."));
        }
    }

    protected static int returnInt(String string) {
        String string2 = "de.renew." + string;
        String string3 = _properties.getProperty(string2);
        int n = -1;
        if (string3 == null) {
            string3 = System.getProperty(string2);
        }
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
                _properties.setProperty(string, Integer.toString(n));
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)("Error reading property " + string2 + "=" + string3 + ": " + numberFormatException));
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: " + string2 + "=" + n));
        }
        return n;
    }

    public static boolean avoidFrameReshape() {
        boolean bl = GUIProperties.returnBool("avoidFrameReshape", "Frame reshaping");
        return bl;
    }

    public static int loadServerPort() {
        return GUIProperties.returnInt("loadServerPort");
    }

    public static int menuFontSize() {
        return GUIProperties.returnInt("menuFontSize");
    }

    public static boolean windowResizable() {
        String string = _properties.getProperty("de.renew.windowResizable");
        if (string == null && (string = System.getProperty("de.renew.windowResizable")) != null) {
            _properties.setProperty("de.renew.windowResizable", string);
        }
        if (string == null) {
            if (System.getProperty("os.name").indexOf("Win") >= 0) {
                string = "true";
                _properties.setProperty("de.renew.windowResizable", string);
            }
        } else if ("".equals(string)) {
            string = "true";
            _properties.setProperty("de.renew.windowResizable", string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: de.renew.windowResizable=" + string));
        }
        Boolean bl = Boolean.valueOf(string);
        GUIProperties.printOptionalSetMessage("de.renew.windowResizable", bl, "Menu frame resizability");
        return bl;
    }

    public static int defaultFontSize() {
        return GUIProperties.returnInt("defaultFontSize");
    }

    public static boolean specialUpdate() {
        Object object;
        String string = _properties.getProperty("CH.ifa.draw.specialUpdate");
        if (string == null && (string = System.getProperty("CH.ifa.draw.specialUpdate")) != null) {
            _properties.setProperty("CH.ifa.draw.specialUpdate", string);
        }
        if (string == null) {
            String string2;
            object = System.getProperty("java.version");
            if (object == null) {
                object = "0.0";
            }
            string = new Boolean(!(string2 = ((String)object).substring(0, 3)).equals("1.0") && !string2.equals("1.1")).toString();
            _properties.setProperty("CH.ifa.draw.specialUpdate", string);
        } else if ("".equals(string)) {
            string = Boolean.TRUE.toString();
            _properties.setProperty("CH.ifa.draw.specialUpdate", string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: CH.ifa.draw.specialUpdate=" + string));
        }
        object = Boolean.valueOf(string);
        GUIProperties.printOptionalSetMessage("CH.ifa.draw.specialUpdate", (Boolean)object, "Special update strategy");
        return (Boolean)object;
    }

    public static boolean customToolBorders() {
        return GUIProperties.returnBool("customToolBorders", "Drawing old-style Renew tool buttons.");
    }

    public static boolean fixMenus() {
        Object object;
        String string = _properties.getProperty("de.renew.fixMenus");
        if (string == null && (string = System.getProperty("de.renew.fixMenus")) != null) {
            _properties.setProperty("de.renew.fixMenus", string);
        }
        if (string == null) {
            object = System.getProperty("java.version");
            if (object == null) {
                object = "0.0";
            }
            String string2 = ((String)object).substring(0, 3);
            string = new Boolean(string2.equals("1.4")).toString();
            _properties.setProperty("de.renew.fixMenus", string);
        } else if ("".equals(string)) {
            string = Boolean.TRUE.toString();
            _properties.setProperty("de.renew.fixMenus", string);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("evaluated GUI property: de.renew.fixMenus=" + string));
        }
        object = Boolean.valueOf(string);
        GUIProperties.printOptionalSetMessage("de.renew.fixMenus", (Boolean)object, "Close menu fix");
        return (Boolean)object;
    }

    public static boolean noGraphics() {
        return GUIProperties.returnBool("noGraphics", null);
    }
}

