/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.standard.MultiLineLabel;
import CH.ifa.draw.util.Fontkit;
import CH.ifa.draw.util.GUIProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MessageDialog
implements ActionListener {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final String SPACE = "  ";
    public static final String DEFAULT_BUTTON_LABEL = " OK ";
    private JButton[] button;
    private JPanel buttonPanel;
    private JDialog alert;
    private int pressedButton;
    private int defaultButton;

    MessageDialog(JFrame jFrame, String string, String[] stringArray) {
        this(jFrame, string, stringArray, DEFAULT_BUTTON_LABEL);
    }

    MessageDialog(JFrame jFrame, String string, String[] stringArray, String string2) {
        this(jFrame, string, stringArray, 1, new String[]{string2});
    }

    MessageDialog(JFrame jFrame, String string, String[] stringArray, String[] stringArray2) {
        this(jFrame, string, stringArray, 1, stringArray2);
    }

    MessageDialog(JFrame jFrame, String string, String[] stringArray, int n, String[] stringArray2) {
        this(jFrame, string, stringArray, n, stringArray2, 2);
    }

    MessageDialog(JFrame jFrame, String string, String[] stringArray, int n, String[] stringArray2, int n2) {
        this.defaultButton = n2;
        this.alert = new JDialog(jFrame, string, true);
        this.alert.getContentPane().setLayout(new BorderLayout());
        this.alert.setBackground(Color.lightGray);
        int n3 = n == 0 ? 0 : 1;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(SPACE);
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(SPACE);
            stringBuffer.append('\n');
        }
        MultiLineLabel multiLineLabel = new MultiLineLabel(stringBuffer.toString(), n3);
        multiLineLabel.setFont(Fontkit.getFont("SansSerif", 1, 13));
        this.alert.getContentPane().add("Center", multiLineLabel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.button = new JButton[stringArray2.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            this.button[i] = new JButton(stringArray2[i]);
            this.button[i].setActionCommand(String.valueOf(i));
            this.button[i].addActionListener(this);
            this.buttonPanel.add(this.button[i]);
        }
        this.alert.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MessageDialog.this.pressedButton = MessageDialog.this.defaultButton;
                MessageDialog.this.alert.setVisible(false);
            }
        });
        this.alert.getContentPane().add("South", this.buttonPanel);
        this.alert.pack();
        if (!GUIProperties.avoidFrameReshape()) {
            this.alert.setLocation(330, 230);
        }
    }

    public static int invokeDialog(JFrame jFrame, String string, String[] stringArray, int n, String[] stringArray2) {
        return MessageDialog.invokeDialog(jFrame, string, stringArray, n, stringArray2, 2);
    }

    public static int invokeDialog(JFrame jFrame, String string, String[] stringArray, int n, String[] stringArray2, int n2) {
        MessageDialog messageDialog = new MessageDialog(jFrame, string, stringArray, n, stringArray2, n2);
        messageDialog.invoke();
        messageDialog.alert.dispose();
        return messageDialog.pressedButton;
    }

    public int invoke() {
        this.pressedButton = this.defaultButton;
        this.alert.setVisible(true);
        return this.pressedButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.pressedButton = Integer.valueOf(actionEvent.getActionCommand());
        this.alert.setVisible(false);
    }

    public void windowClosed() {
        this.pressedButton = this.defaultButton;
        this.alert.setVisible(false);
    }
}

