/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingContext;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;
import de.renew.database.TransactionSource;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.InstanceDrawingFactory;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CPNInstanceDrawing
extends StandardDrawing
implements DrawingChangeListener,
DrawingContext {
    public static Logger logger = Logger.getLogger(CPNInstanceDrawing.class);
    public static String ID_MACRO = "$ID";
    private static Hashtable<String, CPNInstanceDrawing> drawingsByInstance = new Hashtable();
    private static HashMap<Class<?>, InstanceDrawingFactory> instanceDrawingFactories = new HashMap();
    private NetInstanceAccessor netInstance;
    protected CPNDrawing cpnDrawing;
    private Hashtable<FigureWithID, Figure> instanceLookup;

    protected CPNInstanceDrawing(NetInstanceAccessor netInstanceAccessor, CPNDrawing cPNDrawing) throws RemoteException {
        this.cpnDrawing = cPNDrawing;
        this.connect(netInstanceAccessor);
        this.cpnDrawing.addDrawingChangeListener(this);
    }

    public NetInstanceAccessor getNetInstance() {
        return this.netInstance;
    }

    public Rectangle displayBox() {
        return super.displayBox().union(this.cpnDrawing.displayBox());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPNInstanceDrawing getInstanceDrawing(NetInstanceAccessor netInstanceAccessor) throws RemoteException {
        Hashtable<String, CPNInstanceDrawing> hashtable = drawingsByInstance;
        synchronized (hashtable) {
            String string = netInstanceAccessor.getNet().getName() + ":" + netInstanceAccessor.getID();
            if (drawingsByInstance.containsKey(string)) {
                return drawingsByInstance.get(string);
            }
            CPNDrawing cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netInstanceAccessor.getNet().getName());
            if (cPNDrawing != null) {
                CPNInstanceDrawing cPNInstanceDrawing = null;
                InstanceDrawingFactory instanceDrawingFactory = instanceDrawingFactories.get(cPNDrawing.getClass());
                if (instanceDrawingFactory != null) {
                    cPNInstanceDrawing = instanceDrawingFactory.getInstanceDrawing(netInstanceAccessor, cPNDrawing);
                }
                if (cPNInstanceDrawing == null) {
                    cPNInstanceDrawing = new CPNInstanceDrawing(netInstanceAccessor, cPNDrawing);
                }
                return cPNInstanceDrawing;
            }
            String string2 = "Cannot display net instance \"" + netInstanceAccessor.asString() + "\": net drawing not found.";
            logger.error((Object)string2);
            JOptionPane.showMessageDialog(null, string2 + "\nPlease load the net drawing and try again.", "Renew", 0);
            return null;
        }
    }

    public static Enumeration<CPNInstanceDrawing> getDependentInstanceDrawings(CPNDrawing cPNDrawing) {
        Enumeration<CPNInstanceDrawing> enumeration = drawingsByInstance.elements();
        Vector<CPNInstanceDrawing> vector = new Vector<CPNInstanceDrawing>();
        while (enumeration.hasMoreElements()) {
            CPNInstanceDrawing cPNInstanceDrawing = enumeration.nextElement();
            if (cPNInstanceDrawing.cpnDrawing != cPNDrawing) continue;
            vector.addElement(cPNInstanceDrawing);
        }
        if (vector.size() > 0) {
            return vector.elements();
        }
        return null;
    }

    public void draw(Graphics graphics) {
        this.cpnDrawing.draw(graphics, this);
        super.draw(graphics);
    }

    public InstanceFigure getInstanceFigure(Figure figure) {
        try {
            return (InstanceFigure)this.instanceLookup.get(figure);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InstanceFigure getInstanceFigureOfFigureWithID(int n) {
        FigureWithID figureWithID = this.cpnDrawing.getFigureWithID(n);
        if (figureWithID != null) {
            return this.getInstanceFigure((Figure)figureWithID);
        }
        return null;
    }

    private boolean isEmphasized(Figure object) {
        InstanceFigure instanceFigure;
        FigureWithHighlight figureWithHighlight = this.cpnDrawing.getFigureForHighlight((Figure)object);
        if (figureWithHighlight != null) {
            object = figureWithHighlight;
        }
        if ((instanceFigure = this.getInstanceFigure((Figure)object)) != null) {
            return instanceFigure.isHighlighted();
        }
        return false;
    }

    public boolean isLocal() {
        return this.netInstance instanceof NetInstanceAccessorImpl;
    }

    public boolean isHighlighted(Figure figure) {
        return figure.isVisible() && this.isEmphasized(figure);
    }

    public boolean isVisible(Figure figure) {
        return !(!figure.isVisible() && !this.isEmphasized(figure) || figure instanceof CPNTextFigure && ((CPNTextFigure)figure).getType() == 1 && ((CPNTextFigure)figure).parent() instanceof PlaceFigure || figure == this.cpnDrawing.getIconFigure());
    }

    public String expandMacro(String string) {
        return CPNInstanceDrawing.expandMacro(string, this.netInstance);
    }

    public static String expandMacro(String string, NetInstanceAccessor netInstanceAccessor) {
        try {
            return StringUtil.replace((String)string, (String)ID_MACRO, (String)netInstanceAccessor.getID());
        }
        catch (RemoteException remoteException) {
            return remoteException.toString();
        }
    }

    public void connect(NetInstanceAccessor netInstanceAccessor) throws RemoteException {
        if (netInstanceAccessor != null) {
            String string;
            if (this.netInstance != null) {
                string = netInstanceAccessor.getNet().getName() + ":" + netInstanceAccessor.getID();
                drawingsByInstance.remove(string);
                this.notifyTransactionStrategyAboutRelease();
            }
            this.netInstance = netInstanceAccessor;
            string = netInstanceAccessor.getNet().getName() + ":" + netInstanceAccessor.getID();
            drawingsByInstance.put(string, this);
            this.notifyTransactionStrategyAboutConnect();
            this.setName(netInstanceAccessor.asString());
            this.instanceLookup = new Hashtable();
            NetInstanceElementLookup netInstanceElementLookup = this.buildNetElementLookup(netInstanceAccessor);
            Enumeration enumeration = netInstanceElementLookup.getFigures();
            while (enumeration.hasMoreElements()) {
                AbstractFigure abstractFigure;
                FigureWithID figureWithID = (FigureWithID)enumeration.nextElement();
                Hashtable hashtable = netInstanceElementLookup.getNetElements(figureWithID);
                if (hashtable == null) continue;
                if (figureWithID instanceof PlaceFigure) {
                    abstractFigure = ((PlaceFigure)figureWithID).createInstanceFigure(this, hashtable);
                    this.instanceLookup.put(figureWithID, (Figure)abstractFigure);
                    this.add((Figure)abstractFigure);
                    this.sendToBack((Figure)abstractFigure);
                    continue;
                }
                if (!(figureWithID instanceof TransitionFigure)) continue;
                abstractFigure = ((TransitionFigure)figureWithID).createInstanceFigure(this, hashtable);
                this.instanceLookup.put(figureWithID, (Figure)abstractFigure);
                this.add((Figure)abstractFigure);
            }
        }
    }

    public static void registerInstanceDrawingFactory(Class<?> clazz, InstanceDrawingFactory instanceDrawingFactory) {
        instanceDrawingFactories.put(clazz, instanceDrawingFactory);
    }

    protected NetInstanceElementLookup buildNetElementLookup(NetInstanceAccessor netInstanceAccessor) throws RemoteException {
        Hashtable hashtable;
        NetAccessor netAccessor = netInstanceAccessor.getNet();
        String string = netAccessor.getName();
        CPNDrawing cPNDrawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(string);
        if (cPNDrawing == null) {
            logger.error((Object)("No open drawing found matching the compiled net \"" + string + "\""));
            return null;
        }
        Hashtable<Integer, List<Figure>> hashtable2 = new Hashtable<Integer, List<Figure>>();
        this.addToFigureLookup((CompositeFigure)cPNDrawing, hashtable2);
        boolean bl = false;
        boolean bl2 = false;
        NetInstanceElementLookup netInstanceElementLookup = new NetInstanceElementLookup();
        NetElementID[] netElementIDArray = netAccessor.getPlaceIDs();
        for (int i = 0; i < netElementIDArray.length; ++i) {
            List<Figure> list = hashtable2.get(new Integer(netElementIDArray[i].getFigureID()));
            if (list == null) {
                logger.warn((Object)("The place with figure id " + netElementIDArray[i].getFigureID() + " has no corresponding graphical element."));
                bl = true;
                continue;
            }
            for (FigureWithID object : list) {
                netInstanceElementLookup.put(object, netInstanceAccessor.getPlaceInstance(netElementIDArray[i]));
            }
        }
        NetElementID[] netElementIDArray2 = netAccessor.getTransitionIDs();
        for (int i = 0; i < netElementIDArray2.length; ++i) {
            List<Figure> list = hashtable2.get(new Integer(netElementIDArray2[i].getFigureID()));
            if (list == null) {
                logger.warn((Object)("The transition with figure id " + netElementIDArray2[i].getFigureID() + " has no corresponding graphical element."));
                bl = true;
                continue;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                hashtable = (FigureWithID)iterator.next();
                netInstanceElementLookup.put((FigureWithID)hashtable, netInstanceAccessor.getTransitionInstance(netElementIDArray2[i]));
            }
        }
        Enumeration<List<Figure>> enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            for (FigureWithID figureWithID : enumeration.nextElement()) {
                hashtable = netInstanceElementLookup.getNetElements(figureWithID);
                if (hashtable != null && !hashtable.isEmpty()) continue;
                logger.warn((Object)(figureWithID.getClass().getName() + " with id " + figureWithID.getID() + " has no corresponding net element."));
                bl2 = true;
            }
        }
        if (bl) {
            logger.warn((Object)("The compiled net contains one or more net elements with no corresponding graphical element in the drawing \"" + string + "\"."));
            logger.warn((Object)"These net elements will not be displayed.");
        }
        if (bl2) {
            logger.warn((Object)("The drawing \"" + string + "\" contains one or more graphical" + " elements with no corresponding net element."));
            logger.warn((Object)"These graphical elements will not be functional.");
        }
        return netInstanceElementLookup;
    }

    private void addToFigureLookup(CompositeFigure compositeFigure, Hashtable<Integer, List<Figure>> hashtable) {
        FigureEnumeration figureEnumeration = compositeFigure.figures();
        while (figureEnumeration.hasMoreElements()) {
            List<Figure> list;
            Integer n;
            Figure figure = (Figure)figureEnumeration.nextElement();
            if (figure instanceof CompositeFigure) {
                this.addToFigureLookup((CompositeFigure)figure, hashtable);
                continue;
            }
            if (figure instanceof PlaceFigure) {
                n = new Integer(((PlaceFigure)figure).getSemanticPlaceFigure().getID());
                list = hashtable.get(n);
                if (list == null) {
                    list = new ArrayList<Figure>();
                    hashtable.put(n, list);
                }
                list.add(figure);
                continue;
            }
            if (!(figure instanceof TransitionFigure)) continue;
            n = new Integer(((TransitionFigure)figure).getID());
            list = hashtable.get(n);
            if (list == null) {
                list = new ArrayList<Figure>();
                hashtable.put(n, list);
            }
            list.add(figure);
        }
    }

    public void release() {
        this.cpnDrawing.removeDrawingChangeListener(this);
        if (this.netInstance != null) {
            try {
                String string = this.netInstance.getNet().getName() + ":" + this.netInstance.getID();
                drawingsByInstance.remove(string);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
                JOptionPane.showMessageDialog(null, "A problem occurred: " + remoteException + "\n" + "See the console for details.", "Renew", 0);
            }
            this.notifyTransactionStrategyAboutRelease();
            this.instanceLookup = null;
            this.netInstance = null;
        }
        super.release();
    }

    private void notifyTransactionStrategyAboutConnect() {
        try {
            TransactionSource.netInstanceDrawingOpened((String)this.netInstance.getID());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + exception + "\n" + "See the console for details.", "Renew", 0);
        }
    }

    private void notifyTransactionStrategyAboutRelease() {
        try {
            TransactionSource.netInstanceDrawingClosed((String)this.netInstance.getID());
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + exception + "\n" + "See the console for details.", "Renew", 0);
        }
    }

    public void drawingInvalidated(DrawingChangeEvent drawingChangeEvent) {
        DrawingChangeEvent drawingChangeEvent2 = new DrawingChangeEvent((Drawing)this, drawingChangeEvent.getInvalidatedRectangle());
        Enumeration enumeration = this.drawingChangeListeners();
        while (enumeration.hasMoreElements()) {
            DrawingChangeListener drawingChangeListener = (DrawingChangeListener)enumeration.nextElement();
            drawingChangeListener.drawingInvalidated(drawingChangeEvent2);
            drawingChangeListener.drawingRequestUpdate(drawingChangeEvent2);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent drawingChangeEvent) {
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        logger.error((Object)"Figures from net instance drawings may not be removed.");
    }

    public boolean isModified() {
        return false;
    }

    public Dimension defaultSize() {
        return this.cpnDrawing.defaultSize();
    }

    public String getWindowCategory() {
        if (this.isLocal()) {
            return "Net instances";
        }
        return "Remote net instances";
    }

    public void lock() {
        this.cpnDrawing.lock();
        super.lock();
    }

    public void unlock() {
        super.unlock();
        this.cpnDrawing.unlock();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException("CPNInstanceDrawing is not serializable!");
    }

    public static NetInstance[] getAllLocalInstances() {
        Vector<Object> vector = new Vector<Object>(drawingsByInstance.size());
        Enumeration<CPNInstanceDrawing> enumeration = drawingsByInstance.elements();
        while (enumeration.hasMoreElements()) {
            CPNInstanceDrawing cPNInstanceDrawing = enumeration.nextElement();
            if (!cPNInstanceDrawing.isLocal()) continue;
            vector.addElement(((NetInstanceAccessorImpl)cPNInstanceDrawing.getNetInstance()).getObject());
        }
        return vector.toArray(new NetInstance[vector.size()]);
    }

    public File getFilename() {
        return this.cpnDrawing.getFilename();
    }

    private class NetInstanceElementLookup {
        Hashtable<Figure, Hashtable<Serializable, ObjectAccessor>> lookup = new Hashtable();

        private NetInstanceElementLookup() {
        }

        private Enumeration<Figure> getFigures() {
            return this.lookup.keys();
        }

        private Hashtable<Serializable, ObjectAccessor> getNetElements(FigureWithID figureWithID) {
            return this.lookup.get(figureWithID);
        }

        private void put(FigureWithID figureWithID, PlaceInstanceAccessor placeInstanceAccessor) throws RemoteException {
            Hashtable<Serializable, Object> hashtable = this.getNetElements(figureWithID);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.lookup.put((Figure)figureWithID, hashtable);
            }
            hashtable.put(placeInstanceAccessor.getPlace().getID().getGroupID(), (ObjectAccessor)placeInstanceAccessor);
        }

        private void put(FigureWithID figureWithID, TransitionInstanceAccessor transitionInstanceAccessor) throws RemoteException {
            Hashtable<Serializable, Object> hashtable = this.getNetElements(figureWithID);
            if (hashtable == null) {
                hashtable = new Hashtable();
                this.lookup.put((Figure)figureWithID, hashtable);
            }
            hashtable.put(transitionInstanceAccessor.getTransition().getID().getGroupID(), (ObjectAccessor)transitionInstanceAccessor);
        }
    }
}

