/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import de.renew.application.SimulationEnvironment;
import de.renew.application.SimulatorPlugin;
import de.renew.gui.CPNApplication;
import de.renew.gui.ConfigureSimulationDialog;
import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.GuiPlugin;
import de.renew.plugin.PluginManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

class ConfigureSimulationController {
    public static Logger logger = Logger.getLogger(ConfigureSimulationController.class);
    private ConfigureSimulationDialog dialog;
    private ConfigureSimulationTabController[] tabControllers = GuiPlugin.getCurrent().getConfigTabController();

    public ConfigureSimulationController(CPNApplication cPNApplication) {
        Component[] componentArray = new Component[this.tabControllers.length];
        for (int i = 0; i < this.tabControllers.length; ++i) {
            componentArray[i] = this.tabControllers[i].getTab();
        }
        this.dialog = new ConfigureSimulationDialog((Frame)cPNApplication.getFrame(), this, componentArray);
    }

    public void showDialog() {
        if (!this.dialog.isVisible()) {
            this.updateDialog();
            this.dialog.setVisible(true);
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addDialog("Tools", (Dialog)this.dialog);
        }
    }

    public void closeDialog() {
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeDialog((Dialog)this.dialog);
        this.dialog.setVisible(false);
    }

    public void commitDialog() {
        Properties properties = ConfigureSimulationController.getSimulatorPluginProperties();
        for (int i = 0; i < this.tabControllers.length; ++i) {
            this.tabControllers[i].commitTab(properties);
        }
    }

    public void updateDialog() {
        Properties properties = ConfigureSimulationController.getSimulatorPluginProperties();
        for (int i = 0; i < this.tabControllers.length; ++i) {
            this.tabControllers[i].updateTab(properties);
        }
    }

    public void updateDialogFromSimulation() {
        Properties properties = ConfigureSimulationController.getSimulationProperties();
        if (properties != null) {
            for (int i = 0; i < this.tabControllers.length; ++i) {
                this.tabControllers[i].updateTab(properties);
            }
        } else {
            JOptionPane.showMessageDialog(this.dialog, "Could not update properties from current simulation:\nNo simulation running.", "Configure Simulation", 0);
        }
    }

    private static Properties getSimulatorPluginProperties() {
        logger.debug((Object)"ConfigureSimulationController: Reading the simulator plugin's properties.");
        return ConfigureSimulationController.getSimulatorPlugin().getProperties();
    }

    private static Properties getSimulationProperties() {
        Properties properties;
        SimulatorPlugin simulatorPlugin = ConfigureSimulationController.getSimulatorPlugin();
        SimulationEnvironment simulationEnvironment = simulatorPlugin.getCurrentEnvironment();
        if (simulationEnvironment != null) {
            logger.debug((Object)"ConfigureSimulationController: Reading the current simulation's properties.");
            properties = simulationEnvironment.getProperties();
        } else {
            logger.debug((Object)"ConfigureSimulationController: No current simulation available to read properties.");
            properties = null;
        }
        return properties;
    }

    private static SimulatorPlugin getSimulatorPlugin() {
        return (SimulatorPlugin)PluginManager.getInstance().getPluginsProviding("de.renew.simulator").iterator().next();
    }
}

