/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import de.renew.application.SimulatorPlugin;
import de.renew.gui.ActionJList;
import de.renew.gui.CPNApplication;
import de.renew.gui.GuiPlugin;
import de.renew.plugin.command.CLCommand;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class Demonstrator
implements CLCommand {
    public static Logger logger = Logger.getLogger(Demonstrator.class);
    private static JFrame frame = null;
    private static JList list = null;
    private static DefaultListModel listModel = null;

    public String getDescription() {
        return "opens a window with a list of drawing file names";
    }

    public void execute(String[] stringArray, PrintStream printStream) {
        printStream.println("The Renew demonstration GUI");
        if (stringArray.length == 0) {
            printStream.println("Usage: demonstrator files...");
            printStream.println("or     demonstrator -conffile");
        } else if (stringArray[0].startsWith("-")) {
            try {
                Object[] objectArray;
                FileReader fileReader = new FileReader(stringArray[0].substring(1));
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                Vector<Object[]> vector = new Vector<Object[]>();
                while (bufferedReader.ready()) {
                    objectArray = bufferedReader.readLine();
                    if (objectArray == null || objectArray.equals("")) continue;
                    vector.addElement(objectArray);
                }
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                Demonstrator.setup((String[])objectArray);
            }
            catch (Exception exception) {
                printStream.println("Error: could not access configuration file.");
                logger.error((Object)"Could not access configuration file.", (Throwable)exception);
            }
        } else {
            Demonstrator.setup(stringArray);
        }
    }

    public static synchronized void setup(String[] stringArray) {
        if (frame == null) {
            frame = new JFrame("Demonstration Drawings");
            frame.setSize(600, 200);
            GridBagLayout gridBagLayout = new GridBagLayout();
            frame.getContentPane().setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            listModel = new DefaultListModel();
            list = new JList(listModel);
            list.addMouseListener(new ActionJList(list));
            gridBagLayout.setConstraints(list, gridBagConstraints);
            frame.getContentPane().add(list);
            JPanel jPanel = new JPanel();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            frame.getContentPane().add(jPanel);
            gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            JButton jButton = new JButton("Replace");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Demonstrator.replaceDrawings();
                }
            });
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            jButton = new JButton("Include");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Demonstrator.openDrawings();
                }
            });
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
            jButton = new JButton("Exit");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GuiPlugin.getCurrent().closeGui();
                    frame.setVisible(false);
                }
            });
            gridBagLayout.setConstraints(jButton, gridBagConstraints);
            jPanel.add(jButton);
        }
        listModel.removeAllElements();
        for (int i = 0; i < stringArray.length; ++i) {
            listModel.addElement(stringArray[i]);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    static synchronized void replaceDrawings() {
        int n;
        CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
        if (cPNApplication == null) {
            GuiPlugin.getCurrent().openGui();
            cPNApplication = GuiPlugin.getCurrent().getGui();
        }
        if ((n = list.getSelectedIndex()) >= 0 && n < listModel.size()) {
            SimulatorPlugin.getCurrent().terminateSimulation();
            cPNApplication.cleanupSimulationWindows();
            Enumeration enumeration = cPNApplication.drawings();
            while (enumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)enumeration.nextElement();
                cPNApplication.closeDrawing(drawing);
            }
        }
        Demonstrator.openDrawings();
    }

    private static synchronized void openDrawings() {
        int n;
        CPNApplication cPNApplication = GuiPlugin.getCurrent().getGui();
        if (cPNApplication == null) {
            GuiPlugin.getCurrent().openGui();
            cPNApplication = GuiPlugin.getCurrent().getGui();
        }
        if ((n = list.getSelectedIndex()) >= 0 && n < listModel.size()) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)listModel.elementAt(n), ",", false);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreTokens()) {
                vector.add(stringTokenizer.nextToken());
            }
            cPNApplication.loadAndOpenCommandLineDrawings(vector.toArray(new String[vector.size()]));
        }
    }

    public static synchronized void cleanup() {
        if (frame != null) {
            final JFrame jFrame = frame;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        frame = null;
        list = null;
        listModel = null;
    }
}

